/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.subsets;

import com.carrotsearch.hppc.BitSet;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.subsets.AbstractAnyBasedSegmentator;

public class OneAny
extends AbstractAnyBasedSegmentator {
    public OneAny() {
    }

    public OneAny(int maxSubSetSize, boolean isSubSetUnionSize) {
        super(maxSubSetSize, isSubSetUnionSize);
    }

    @Override
    protected SegmentationDefinition getSubsetDefinitionWithoutRestrictions(int wordsetSize) {
        int mask = (1 << wordsetSize) - 1;
        int posInResult = 0;
        int[] segments = new int[wordsetSize];
        int[][] conditions = new int[segments.length][];
        int bit = 1;
        while (bit < mask) {
            segments[posInResult] = bit;
            conditions[posInResult] = this.createConditions(mask - bit);
            bit <<= 1;
            ++posInResult;
        }
        BitSet neededCounts = new BitSet(1 << wordsetSize);
        neededCounts.set(1L, 1 << wordsetSize);
        return new SegmentationDefinition(segments, conditions, neededCounts);
    }

    @Override
    protected SegmentationDefinition getSubsetDefinitionWithRestrictions(int wordsetSize, int maxSingleSubSetSize, int maxSubSetUnionSize) {
        int conditionRestriction;
        int mask = (1 << wordsetSize) - 1;
        int posInResult = 0;
        int[] segments = new int[wordsetSize];
        int[][] conditions = new int[segments.length][];
        int bit = 1;
        int n = conditionRestriction = maxSubSetUnionSize > maxSingleSubSetSize ? maxSingleSubSetSize : maxSubSetUnionSize - 1;
        while (bit < mask) {
            segments[posInResult] = bit;
            conditions[posInResult] = this.createRestrictedConditions(mask - bit, conditionRestriction);
            bit <<= 1;
            ++posInResult;
        }
        BitSet neededCounts = new BitSet(1 << wordsetSize);
        neededCounts.set(1L, 1 << wordsetSize);
        return new SegmentationDefinition(segments, conditions, neededCounts);
    }

    @Override
    public String getName() {
        if (this.isSingleSubSetSizeRestricted()) {
            return "S^{one}_{any(" + this.getMaxSingleSubSetSize() + ")}";
        }
        return "S^{one}_{any}";
    }
}

