/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.subsets;

import com.carrotsearch.hppc.BitSet;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.subsets.AbstractAnyBasedSegmentator;

public class AnyAny
extends AbstractAnyBasedSegmentator {
    public AnyAny() {
    }

    public AnyAny(int maxSubSetSize, boolean isSubSetUnionSize) {
        super(maxSubSetSize, isSubSetUnionSize);
    }

    @Override
    protected SegmentationDefinition getSubsetDefinitionWithoutRestrictions(int wordsetSize) {
        int mask = (1 << wordsetSize) - 1;
        int posInResult = 0;
        int[] segments = new int[mask - 1];
        int[][] conditions = new int[segments.length][];
        for (int i = 1; i < mask; ++i) {
            segments[posInResult] = i;
            conditions[posInResult] = this.createConditions(mask - i);
            ++posInResult;
        }
        BitSet neededCounts = new BitSet(1 << wordsetSize);
        neededCounts.set(1L, 1 << wordsetSize);
        return new SegmentationDefinition(segments, conditions, neededCounts);
    }

    @Override
    protected SegmentationDefinition getSubsetDefinitionWithRestrictions(int wordsetSize, int maxSingleSubSetSize, int maxSubSetUnionSize) {
        int maxSegmentSize = maxSubSetUnionSize > maxSingleSubSetSize ? maxSingleSubSetSize : maxSubSetUnionSize - 1;
        int mask = (1 << wordsetSize) - 1;
        int posInResult = 0;
        int[] segments = new int[this.getNumberOfCombinations(wordsetSize, maxSegmentSize)];
        int[][] conditions = new int[segments.length][];
        for (int i = 1; i < mask; ++i) {
            int segmentBitCount = Integer.bitCount(i);
            if (segmentBitCount > maxSegmentSize) continue;
            segments[posInResult] = i;
            conditions[posInResult] = this.createRestrictedConditions(mask - i, Math.min(maxSingleSubSetSize, maxSubSetUnionSize - segmentBitCount));
            ++posInResult;
        }
        BitSet neededCounts = new BitSet(1 << wordsetSize);
        neededCounts.set(1L, 1 << wordsetSize);
        return new SegmentationDefinition(segments, conditions, neededCounts);
    }

    @Override
    public String getName() {
        if (this.isSingleSubSetSizeRestricted()) {
            return "S^{any(" + this.getMaxSingleSubSetSize() + ")}_{any(" + this.getMaxSingleSubSetSize() + ")}";
        }
        if (this.isSubSetUnionSizeRestricted()) {
            return "S^{any}_{any}(" + this.getMaxSubSetUnionSize() + ")";
        }
        return "S^{any}_{any}";
    }
}

