/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.subsets;

import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.subsets.Segmentator;

public abstract class AbstractAnyBasedSegmentator
implements Segmentator {
    private int maxSingleSubSetSize = 32;
    private int maxSubSetUnionSize = 32;
    private int[] factorials;

    public AbstractAnyBasedSegmentator() {
    }

    public AbstractAnyBasedSegmentator(int maxSubSetSize, boolean isSubSetUnionSize) {
        if (isSubSetUnionSize) {
            this.maxSubSetUnionSize = maxSubSetSize;
        } else {
            this.maxSingleSubSetSize = maxSubSetSize;
        }
        this.createOrIncreaseFactorials(maxSubSetSize);
    }

    private void createOrIncreaseFactorials(int subSetSize) {
        int startId;
        if (this.factorials == null) {
            this.factorials = new int[subSetSize + 1];
            this.factorials[0] = 1;
            startId = 1;
        } else {
            int[] temp = new int[subSetSize + 1];
            System.arraycopy(this.factorials, 0, temp, 0, this.factorials.length);
            startId = this.factorials.length;
            this.factorials = temp;
        }
        for (int i = startId; i < this.factorials.length; ++i) {
            this.factorials[i] = this.factorials[i - 1] * i;
        }
    }

    @Override
    public SegmentationDefinition getSubsetDefinition(int wordsetSize) {
        if (this.maxSingleSubSetSize < wordsetSize - 1 || this.maxSubSetUnionSize < wordsetSize) {
            return this.getSubsetDefinitionWithRestrictions(wordsetSize, this.maxSingleSubSetSize, this.maxSubSetUnionSize);
        }
        return this.getSubsetDefinitionWithoutRestrictions(wordsetSize);
    }

    protected abstract SegmentationDefinition getSubsetDefinitionWithoutRestrictions(int var1);

    protected abstract SegmentationDefinition getSubsetDefinitionWithRestrictions(int var1, int var2, int var3);

    protected int[] createConditions(int condition) {
        int card = Integer.bitCount(condition);
        int[] conditions = new int[(1 << card) - 1];
        int bit = 1;
        int count = 0;
        while (count < card) {
            if ((bit & condition) > 0) {
                int pos = (1 << count) - 1;
                conditions[pos] = bit;
                int pos2 = pos + 1;
                for (int j = 0; j < pos; ++j) {
                    conditions[pos2] = conditions[j] | bit;
                    ++pos2;
                }
                ++count;
            }
            bit <<= 1;
        }
        return conditions;
    }

    protected int[] createRestrictedConditions(int condition, int maxConditionSize) {
        int wordsAvailable = Integer.bitCount(condition);
        if (wordsAvailable <= maxConditionSize) {
            return this.createConditions(condition);
        }
        int numberOfConditions = this.getNumberOfCombinations(wordsAvailable, maxConditionSize);
        int[] conditions = new int[numberOfConditions];
        int pos = 0;
        for (int bit = 1; bit <= condition; bit <<= 1) {
            if ((bit & condition) <= 0) continue;
            conditions[pos] = bit;
            int pos2 = pos++;
            for (int j = 0; j < pos2; ++j) {
                if (Integer.bitCount(conditions[j]) >= maxConditionSize) continue;
                conditions[pos] = conditions[j] | bit;
                ++pos;
            }
        }
        return conditions;
    }

    protected int getNumberOfCombinations(int elementCount, int maxElementsPerCombination) {
        if (this.factorials.length <= elementCount) {
            this.createOrIncreaseFactorials(elementCount);
        }
        int numberOfCombinations = elementCount;
        for (int i = 2; i <= maxElementsPerCombination; ++i) {
            numberOfCombinations += this.factorials[elementCount] / (this.factorials[i] * this.factorials[elementCount - i]);
        }
        return numberOfCombinations;
    }

    protected boolean isSingleSubSetSizeRestricted() {
        return this.maxSingleSubSetSize != 32;
    }

    protected boolean isSubSetUnionSizeRestricted() {
        return this.maxSubSetUnionSize != 32;
    }

    public int getMaxSingleSubSetSize() {
        return this.maxSingleSubSetSize;
    }

    public int getMaxSubSetUnionSize() {
        return this.maxSubSetUnionSize;
    }
}

