/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob.window;

import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.prob.AbstractProbabilitySupplier;
import org.aksw.palmetto.prob.window.WindowBasedFrequencyDeterminer;

public class WindowBasedProbabilityEstimator
extends AbstractProbabilitySupplier {
    private long[] cooccurrenceCountsSums;

    public WindowBasedProbabilityEstimator(WindowBasedFrequencyDeterminer freqDeterminer) {
        super(freqDeterminer);
        this.cooccurrenceCountsSums = freqDeterminer.getCooccurrenceCounts();
    }

    @Override
    protected SubsetProbabilities getProbabilities(CountedSubsets countedSubsets) {
        double[] probabilities = new double[countedSubsets.counts.length];
        for (int i = 1; i < probabilities.length; i <<= 1) {
            if (countedSubsets.counts[i] < this.minFrequency) continue;
            probabilities[i] = (double)countedSubsets.counts[i] / (double)this.cooccurrenceCountsSums[0];
            for (int j = 1; j < i; ++j) {
                int wordSet = i | j;
                if (countedSubsets.counts[wordSet] < this.minFrequency) continue;
                probabilities[wordSet] = (double)countedSubsets.counts[wordSet] / (double)this.cooccurrenceCountsSums[Integer.bitCount(wordSet) - 1];
            }
        }
        return new SubsetProbabilities(countedSubsets.segments, countedSubsets.conditions, probabilities);
    }

    @Override
    public String getName() {
        return ((WindowBasedFrequencyDeterminer)this.freqDeterminer).getSlidingWindowModelName();
    }
}

