/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob.window;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import java.util.Arrays;
import org.aksw.palmetto.corpus.WindowSupportingAdapter;
import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.prob.window.WindowBasedFrequencyDeterminer;

public class ContextWindowFrequencyDeterminer
implements WindowBasedFrequencyDeterminer {
    private WindowSupportingAdapter corpusAdapter;
    private int windowSize;
    private long[] wordSetCountSums;

    public ContextWindowFrequencyDeterminer(WindowSupportingAdapter corpusAdapter, int windowSize) {
        this.corpusAdapter = corpusAdapter;
        this.setWindowSize(windowSize);
    }

    @Override
    public CountedSubsets[] determineCounts(String[][] wordsets, SegmentationDefinition[] definitions) {
        CountedSubsets[] countedSubsets = new CountedSubsets[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            countedSubsets[i] = new CountedSubsets(definitions[i].segments, definitions[i].conditions, this.determineCounts(wordsets[i]));
        }
        return countedSubsets;
    }

    private int[] determineCounts(String[] wordset) {
        int[] counts = new int[1 << wordset.length];
        IntIntOpenHashMap docLengths = new IntIntOpenHashMap();
        IntObjectOpenHashMap<IntArrayList[]> positionsInDocs = this.corpusAdapter.requestWordPositionsInDocuments(wordset, docLengths);
        for (int i = 0; i < positionsInDocs.keys.length; ++i) {
            if (!positionsInDocs.allocated[i]) continue;
            IntArrayList[] positions = (IntArrayList[])positionsInDocs.values[i];
            this.addCountsFromDocument(positions, counts, docLengths.get(positionsInDocs.keys[i]));
        }
        return counts;
    }

    private void addCountsFromDocument(IntArrayList[] positions, int[] counts, int docLength) {
        int[] posInList = new int[positions.length];
        int nextWordId = 0;
        int nextWordPos = Integer.MAX_VALUE;
        int wordCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] == null) continue;
            Arrays.sort(positions[i].buffer, 0, positions[i].elementsCount);
            if (positions[i].buffer[0] < nextWordPos) {
                nextWordPos = positions[i].buffer[0];
                nextWordId = i;
            }
            wordCount += positions[i].elementsCount;
        }
        int[] wordIds = new int[wordCount];
        int[] wordPositions = new int[wordCount];
        wordCount = 0;
        while (nextWordPos < docLength) {
            wordIds[wordCount] = nextWordId;
            wordPositions[wordCount] = nextWordPos;
            int n = nextWordId;
            posInList[n] = posInList[n] + 1;
            ++wordCount;
            nextWordPos = Integer.MAX_VALUE;
            for (int i = 0; i < positions.length; ++i) {
                if (positions[i] == null || posInList[i] >= positions[i].elementsCount || positions[i].buffer[posInList[i]] >= nextWordPos) continue;
                nextWordPos = positions[i].buffer[posInList[i]];
                nextWordId = i;
            }
        }
        for (int i = 0; i < wordIds.length; ++i) {
            int windowEndPos = i + 1;
            for (int windowStartPos = i; windowStartPos > 0 && wordPositions[windowStartPos - 1] >= wordPositions[i] - this.windowSize; --windowStartPos) {
            }
            while (windowEndPos < wordPositions.length && wordPositions[windowEndPos] <= wordPositions[i] + this.windowSize) {
                ++windowEndPos;
            }
            int currentWordBit = 1 << wordIds[i];
            for (int j = windowStartPos; j < windowEndPos; ++j) {
                if (wordIds[i] >= wordIds[j]) continue;
                int n = currentWordBit | 1 << wordIds[j];
                counts[n] = counts[n] + 1;
            }
            int n = currentWordBit;
            counts[n] = counts[n] + 1;
        }
    }

    @Override
    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        this.determineWordSetCountSum();
    }

    @Override
    public long[] getCooccurrenceCounts() {
        return this.wordSetCountSums;
    }

    @Override
    public String getSlidingWindowModelName() {
        return "P_cw" + this.windowSize;
    }

    protected void determineWordSetCountSum() {
        int i;
        this.wordSetCountSums = new long[this.windowSize];
        int numberOfWindowsInDocs = 0;
        int[][] histogram = this.corpusAdapter.getDocumentSizeHistogram();
        for (i = 0; i < histogram.length; ++i) {
            numberOfWindowsInDocs += histogram[i][1] * (histogram[i][0] - (this.windowSize - 1));
        }
        for (i = 0; i < this.wordSetCountSums.length; ++i) {
            this.wordSetCountSums[i] = numberOfWindowsInDocs;
        }
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }
}

