/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob.window;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import java.util.Arrays;
import org.aksw.palmetto.corpus.WindowSupportingAdapter;
import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.prob.window.WindowBasedFrequencyDeterminer;

public class BooleanSlidingWindowFrequencyDeterminer
implements WindowBasedFrequencyDeterminer {
    protected WindowSupportingAdapter corpusAdapter;
    protected int windowSize;
    protected long[] wordSetCountSums;

    public BooleanSlidingWindowFrequencyDeterminer(WindowSupportingAdapter corpusAdapter, int windowSize) {
        this.corpusAdapter = corpusAdapter;
        this.setWindowSize(windowSize);
    }

    @Override
    public CountedSubsets[] determineCounts(String[][] wordsets, SegmentationDefinition[] definitions) {
        CountedSubsets[] countedSubsets = new CountedSubsets[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            countedSubsets[i] = new CountedSubsets(definitions[i].segments, definitions[i].conditions, this.determineCounts(wordsets[i]));
        }
        return countedSubsets;
    }

    protected int[] determineCounts(String[] wordset) {
        int[] counts = new int[1 << wordset.length];
        IntIntOpenHashMap docLengths = new IntIntOpenHashMap();
        IntObjectOpenHashMap<IntArrayList[]> positionsInDocs = this.corpusAdapter.requestWordPositionsInDocuments(wordset, docLengths);
        for (int i = 0; i < positionsInDocs.keys.length; ++i) {
            if (!positionsInDocs.allocated[i]) continue;
            IntArrayList[] positions = (IntArrayList[])positionsInDocs.values[i];
            this.addCountsFromDocument(positions, counts, docLengths.get(positionsInDocs.keys[i]));
        }
        this.addCountsOfSubsets(counts);
        return counts;
    }

    protected void addCountsFromDocument(IntArrayList[] positions, int[] counts, int docLength) {
        if (docLength <= this.windowSize) {
            this.addCountsFromSmallDocument(positions, counts);
            return;
        }
        int[] posInList = new int[positions.length + 1];
        int nextWordId = 0;
        int nextWordPos = Integer.MAX_VALUE;
        int wordCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] == null) continue;
            Arrays.sort(positions[i].buffer, 0, positions[i].elementsCount);
            if (positions[i].buffer[0] < nextWordPos) {
                nextWordPos = positions[i].buffer[0];
                nextWordId = i;
            }
            wordCount += positions[i].elementsCount;
        }
        IntArrayList wordIdsInWindow = new IntArrayList(wordCount < this.windowSize ? wordCount : this.windowSize);
        IntArrayList wordPositionsInWindow = new IntArrayList(wordCount < this.windowSize ? wordCount : this.windowSize);
        int romaveableWordsPosId = posInList.length - 1;
        int windowWords = 0;
        boolean countingEnabled = false;
        while (nextWordPos < docLength) {
            int i;
            if (nextWordId == positions.length) {
                windowWords &= ~(1 << wordIdsInWindow.buffer[posInList[romaveableWordsPosId]]);
                int n = romaveableWordsPosId;
                posInList[n] = posInList[n] + 1;
            } else {
                int wordEndPos;
                if ((windowWords & 1 << nextWordId) > 0) {
                    for (i = posInList[romaveableWordsPosId]; i < wordIdsInWindow.elementsCount; ++i) {
                        if (wordIdsInWindow.buffer[i] != nextWordId) continue;
                        wordIdsInWindow.remove(i);
                        wordPositionsInWindow.remove(i);
                    }
                } else {
                    windowWords |= 1 << nextWordId;
                }
                if ((wordEndPos = nextWordPos + this.windowSize) < docLength) {
                    wordIdsInWindow.add(nextWordId);
                    wordPositionsInWindow.add(wordEndPos);
                }
                if (posInList[romaveableWordsPosId] < wordPositionsInWindow.elementsCount && wordPositionsInWindow.buffer[posInList[romaveableWordsPosId]] == nextWordPos) {
                    windowWords &= ~(1 << wordIdsInWindow.buffer[posInList[romaveableWordsPosId]]);
                    int n = romaveableWordsPosId;
                    posInList[n] = posInList[n] + 1;
                }
                int n = nextWordId;
                posInList[n] = posInList[n] + 1;
            }
            int lastWordPos = nextWordPos;
            nextWordPos = Integer.MAX_VALUE;
            for (i = 0; i < positions.length; ++i) {
                if (positions[i] == null || posInList[i] >= positions[i].elementsCount || positions[i].buffer[posInList[i]] >= nextWordPos) continue;
                nextWordPos = positions[i].buffer[posInList[i]];
                nextWordId = i;
            }
            if (posInList[romaveableWordsPosId] < wordPositionsInWindow.elementsCount && wordPositionsInWindow.buffer[posInList[romaveableWordsPosId]] < nextWordPos) {
                nextWordPos = wordPositionsInWindow.buffer[posInList[romaveableWordsPosId]];
                nextWordId = positions.length;
            }
            if (!countingEnabled && nextWordPos >= this.windowSize) {
                if (lastWordPos < this.windowSize) {
                    lastWordPos = this.windowSize - 1;
                }
                countingEnabled = true;
            }
            if (!countingEnabled || windowWords == 0) continue;
            if (nextWordPos < docLength) {
                int n = windowWords;
                counts[n] = counts[n] + (nextWordPos - lastWordPos);
                continue;
            }
            int n = windowWords;
            counts[n] = counts[n] + (docLength - lastWordPos);
        }
    }

    protected void addCountsFromSmallDocument(IntArrayList[] positions, int[] counts) {
        int signature = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] == null || positions[i].size() <= 0) continue;
            signature |= 1 << i;
        }
        int n = signature;
        counts[n] = counts[n] + 1;
    }

    protected void addCountsOfSubsets(int[] counts) {
        for (int i = 1; i < counts.length; ++i) {
            for (int j = i + 1; j < counts.length; ++j) {
                if ((i & j) != i) continue;
                int n = i;
                counts[n] = counts[n] + counts[j];
            }
        }
    }

    @Override
    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        this.determineWordSetCountSum();
    }

    @Override
    public long[] getCooccurrenceCounts() {
        return this.wordSetCountSums;
    }

    @Override
    public String getSlidingWindowModelName() {
        return "P_sw" + this.windowSize;
    }

    protected void determineWordSetCountSum() {
        int i;
        this.wordSetCountSums = new long[this.windowSize];
        int numberOfWindowsInDocs = 0;
        int[][] histogram = this.corpusAdapter.getDocumentSizeHistogram();
        for (i = 0; i < histogram.length; ++i) {
            if (histogram[i][0] < this.windowSize) {
                numberOfWindowsInDocs += histogram[i][1];
                continue;
            }
            numberOfWindowsInDocs += histogram[i][1] * (histogram[i][0] - (this.windowSize - 1));
        }
        for (i = 0; i < this.wordSetCountSums.length; ++i) {
            this.wordSetCountSums[i] = numberOfWindowsInDocs;
        }
    }

    @Override
    public int getWindowSize() {
        return this.windowSize;
    }
}

