/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob.decorator;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import java.util.Arrays;
import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.prob.FrequencyDeterminer;
import org.aksw.palmetto.prob.decorator.AbstractSlidingWindowFrequencyDeterminerDecorator;

public class FreqeuencyCachingDeterminerDecorator
extends AbstractSlidingWindowFrequencyDeterminerDecorator {
    private IntObjectOpenHashMap<int[]> cache = new IntObjectOpenHashMap();

    public FreqeuencyCachingDeterminerDecorator(FrequencyDeterminer determiner) {
        super(determiner);
    }

    @Override
    public CountedSubsets[] determineCounts(String[][] wordsets, SegmentationDefinition[] definitions) {
        CountedSubsets[] countedSubsets = new CountedSubsets[definitions.length];
        String[][] singleWordSet = new String[1][];
        SegmentationDefinition[] singleDefinition = new SegmentationDefinition[1];
        for (int i = 0; i < definitions.length; ++i) {
            int wordSetHash = Arrays.hashCode(wordsets[i]);
            if (this.cache.containsKey(wordSetHash)) {
                countedSubsets[i] = new CountedSubsets(definitions[i].segments, definitions[i].conditions, this.cache.get(wordSetHash));
                continue;
            }
            singleWordSet[0] = wordsets[i];
            singleDefinition[0] = definitions[i];
            countedSubsets[i] = this.determiner.determineCounts(singleWordSet, singleDefinition)[0];
            this.cache.put(wordSetHash, countedSubsets[i].counts);
        }
        return countedSubsets;
    }
}

