/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob.bd;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.ObjectObjectOpenHashMap;
import java.util.Arrays;
import org.aksw.palmetto.corpus.BooleanDocumentSupportingAdapter;
import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.prob.bd.BooleanDocumentFrequencyDeterminer;

public class ListBasedBooleanDocumentFrequencyDeterminer
implements BooleanDocumentFrequencyDeterminer {
    private BooleanDocumentSupportingAdapter corpusAdapter;

    public ListBasedBooleanDocumentFrequencyDeterminer(BooleanDocumentSupportingAdapter corpusAdapter) {
        this.corpusAdapter = corpusAdapter;
    }

    @Override
    public int getNumberOfDocuments() {
        return this.corpusAdapter.getNumberOfDocuments();
    }

    @Override
    public CountedSubsets[] determineCounts(String[][] wordsets, SegmentationDefinition[] definitions) {
        ObjectObjectOpenHashMap<String, IntArrayList> wordDocMapping = new ObjectObjectOpenHashMap<String, IntArrayList>();
        for (int i = 0; i < wordsets.length; ++i) {
            for (int j = 0; j < wordsets[i].length; ++j) {
                if (wordDocMapping.containsKey(wordsets[i][j])) continue;
                wordDocMapping.put(wordsets[i][j], new IntArrayList());
            }
        }
        this.corpusAdapter.getDocumentsWithWords(wordDocMapping);
        CountedSubsets[] countedSubsets = new CountedSubsets[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            int[] counts = this.createCounts(wordDocMapping, wordsets[i]);
            this.addCountsOfSubsets(counts);
            countedSubsets[i] = new CountedSubsets(definitions[i].segments, definitions[i].conditions, counts);
        }
        return countedSubsets;
    }

    private void addCountsOfSubsets(int[] counts) {
        for (int i = 1; i < counts.length; ++i) {
            for (int j = i + 1; j < counts.length; ++j) {
                if ((i & j) != i) continue;
                int n = i;
                counts[n] = counts[n] + counts[j];
            }
        }
    }

    private int[] createCounts(ObjectObjectOpenHashMap<String, IntArrayList> wordDocMapping, String[] wordset) {
        int nextDocId;
        int[] counts = new int[1 << wordset.length];
        IntArrayList[] wordDocuments = new IntArrayList[wordset.length];
        for (int i = 0; i < wordDocuments.length; ++i) {
            wordDocuments[i] = wordDocMapping.get(wordset[i]);
            Arrays.sort(wordDocuments[i].buffer, 0, wordDocuments[i].elementsCount);
        }
        int[] posInList = new int[wordDocuments.length];
        int documentSignature = 0;
        counts[0] = -1;
        do {
            int i;
            int n = documentSignature;
            counts[n] = counts[n] + 1;
            nextDocId = Integer.MAX_VALUE;
            for (i = 0; i < wordDocuments.length; ++i) {
                if (posInList[i] >= wordDocuments[i].elementsCount || wordDocuments[i].buffer[posInList[i]] > nextDocId) continue;
                if (wordDocuments[i].buffer[posInList[i]] < nextDocId) {
                    nextDocId = wordDocuments[i].buffer[posInList[i]];
                    documentSignature = 0;
                }
                documentSignature |= 1 << i;
            }
            for (i = 0; i < posInList.length; ++i) {
                if ((documentSignature & 1 << i) <= 0) continue;
                int n2 = i;
                posInList[n2] = posInList[n2] + 1;
            }
        } while (nextDocId != Integer.MAX_VALUE);
        return counts;
    }
}

