/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob.bd;

import org.aksw.palmetto.corpus.BooleanDocumentSupportingAdapter;
import org.aksw.palmetto.corpus.CorpusAdapter;
import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.prob.AbstractProbabilitySupplier;
import org.aksw.palmetto.prob.bd.BitSetBasedBooleanDocumentFrequencyDeterminer;
import org.aksw.palmetto.prob.bd.BooleanDocumentFrequencyDeterminer;
import org.aksw.palmetto.prob.bd.ListBasedBooleanDocumentFrequencyDeterminer;

public class BooleanDocumentProbabilitySupplier
extends AbstractProbabilitySupplier {
    private static final String DEFAULT_PROB_MODEL_NAME = "bd";
    private int numberOfDocuments;
    private String probModelName;

    public static BooleanDocumentProbabilitySupplier create(CorpusAdapter adapter) {
        return BooleanDocumentProbabilitySupplier.create(adapter, DEFAULT_PROB_MODEL_NAME);
    }

    public static BooleanDocumentProbabilitySupplier create(CorpusAdapter adapter, String probModelName) {
        return BooleanDocumentProbabilitySupplier.create(adapter, probModelName, false);
    }

    public static BooleanDocumentProbabilitySupplier create(CorpusAdapter adapter, String probModelName, boolean corpusIsLarge) {
        BooleanDocumentFrequencyDeterminer determiner = BooleanDocumentProbabilitySupplier.createFrequencyDeterminer(adapter, corpusIsLarge);
        if (determiner != null) {
            return new BooleanDocumentProbabilitySupplier(determiner, probModelName);
        }
        return null;
    }

    protected static BooleanDocumentFrequencyDeterminer createFrequencyDeterminer(CorpusAdapter adapter, boolean corpusIsLarge) {
        if (adapter instanceof BooleanDocumentSupportingAdapter) {
            return corpusIsLarge ? new ListBasedBooleanDocumentFrequencyDeterminer((BooleanDocumentSupportingAdapter)adapter) : new BitSetBasedBooleanDocumentFrequencyDeterminer((BooleanDocumentSupportingAdapter)adapter);
        }
        return null;
    }

    protected BooleanDocumentProbabilitySupplier(BooleanDocumentFrequencyDeterminer freqDeterminer, String probModelName) {
        super(freqDeterminer);
        this.probModelName = probModelName;
        this.numberOfDocuments = freqDeterminer.getNumberOfDocuments();
    }

    @Override
    protected SubsetProbabilities getProbabilities(CountedSubsets countedSubsets) {
        double[] probabilities = new double[countedSubsets.counts.length];
        double numberOfDocuments = this.numberOfDocuments;
        for (int i = 0; i < probabilities.length; ++i) {
            probabilities[i] = countedSubsets.counts[i] >= this.minFrequency ? (double)countedSubsets.counts[i] / numberOfDocuments : 0.0;
        }
        return new SubsetProbabilities(countedSubsets.segments, countedSubsets.conditions, probabilities);
    }

    @Override
    public String getName() {
        return "P_" + this.probModelName;
    }
}

