/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.prob;

import org.aksw.palmetto.data.CountedSubsets;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.prob.FrequencyDeterminer;
import org.aksw.palmetto.prob.ProbabilityEstimator;

public abstract class AbstractProbabilitySupplier
implements ProbabilityEstimator {
    public static final int DEFAULT_MIN_FREQUENCY = 10;
    protected FrequencyDeterminer freqDeterminer;
    protected int minFrequency = 10;

    protected AbstractProbabilitySupplier(FrequencyDeterminer freqDeterminer) {
        this.freqDeterminer = freqDeterminer;
    }

    @Override
    public SubsetProbabilities[] getProbabilities(String[][] wordsets, SegmentationDefinition[] definitions) {
        CountedSubsets[] subsets = this.freqDeterminer.determineCounts(wordsets, definitions);
        SubsetProbabilities[] probabilities = new SubsetProbabilities[subsets.length];
        for (int i = 0; i < subsets.length; ++i) {
            probabilities[i] = this.getProbabilities(subsets[i]);
        }
        return probabilities;
    }

    protected abstract SubsetProbabilities getProbabilities(CountedSubsets var1);

    @Override
    public void setMinFrequency(int minFrequency) {
        this.minFrequency = minFrequency;
    }

    public int getMinFrequency() {
        return this.minFrequency;
    }

    @Override
    public FrequencyDeterminer getFrequencyDeterminer() {
        return this.freqDeterminer;
    }

    @Override
    public void setFrequencyDeterminer(FrequencyDeterminer freqDeterminer) {
        this.freqDeterminer = freqDeterminer;
    }
}

