/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.io;

import com.carrotsearch.hppc.DoubleArrayList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldStandardReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoldStandardReader.class);

    public static double[] readGoldStandard(String file) throws IOException {
        List<String> lines = FileUtils.readLines(new File(file));
        DoubleArrayList ratings = new DoubleArrayList();
        for (String line : lines) {
            try {
                ratings.add(Double.parseDouble(line));
            }
            catch (NumberFormatException e) {
                throw new IOException("Error while reading gold standard.", e);
            }
        }
        return ratings.toArray();
    }

    public static double[] readGoldStandardSavely(String file) {
        double[] ratings = null;
        try {
            ratings = GoldStandardReader.readGoldStandard(file);
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to read the gold standard. Returning null.", e);
        }
        return ratings;
    }
}

