/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.evaluate.correlation;

import java.util.Arrays;
import org.aksw.palmetto.evaluate.correlation.RankCorrelationCalculator;

public class Spearman
implements RankCorrelationCalculator {
    @Override
    public double calculateRankCorrelation(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The x and y array must have the same size!");
        }
        Object[] sortedX = new ValuePair[x.length];
        Object[] sortedY = new ValuePair[y.length];
        for (int i = 0; i < x.length; ++i) {
            sortedX[i] = new ValuePair(x[i], i);
            sortedY[i] = new ValuePair(y[i], i);
            if (!Double.isNaN(x[i]) && !Double.isNaN(y[i])) continue;
            System.out.println("STOP!");
        }
        try {
            Arrays.sort(sortedX);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(Arrays.toString(sortedX));
            return -1.0;
        }
        try {
            Arrays.sort(sortedY);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(Arrays.toString(sortedY));
            return -1.0;
        }
        double[] ranks1 = this.createRanks((ValuePair[])sortedX);
        double[] ranks2 = this.createRanks((ValuePair[])sortedY);
        return this.calculateRankCorrelationUsingRanks(ranks1, ranks2);
    }

    private double[] createRanks(ValuePair[] sortedPairs) {
        double[] ranks = new double[sortedPairs.length];
        int highestRank = 0;
        while (highestRank < sortedPairs.length) {
            int lowestRank = highestRank++;
            while (highestRank < sortedPairs.length && sortedPairs[lowestRank].first == sortedPairs[highestRank].first) {
                ++highestRank;
            }
            double rank = (double)(lowestRank + 1 + highestRank) / 2.0;
            for (int i = lowestRank; i < highestRank; ++i) {
                ranks[sortedPairs[i].second] = rank;
            }
        }
        return ranks;
    }

    private double calculateRankCorrelationUsingRanks(double[] ranks1, double[] ranks2) {
        double sum = 0.0;
        for (int i = 0; i < ranks1.length; ++i) {
            sum += Math.pow(ranks1[i] - ranks2[i], 2.0);
        }
        return 1.0 - 6.0 * sum / ((double)ranks1.length * (Math.pow(ranks1.length, 2.0) - 1.0));
    }

    protected static class ValuePair
    implements Comparable<ValuePair> {
        public double first;
        public int second;

        public ValuePair(double first, int second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compareTo(ValuePair v) {
            if (Double.isNaN(this.first)) {
                if (Double.isNaN(v.first)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(v.first)) {
                return 1;
            }
            if (this.first < v.first) {
                return -1;
            }
            if (this.first > v.first) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "(" + this.first + "|" + this.second + ")";
        }
    }
}

