/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.evaluate.correlation;

import org.aksw.palmetto.evaluate.correlation.RankCorrelationCalculator;

public class PearsonsSampleCorrelationCoefficient
implements RankCorrelationCalculator {
    @Override
    public double calculateRankCorrelation(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The x and y array must have the same size!");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("The x and y array must have a minimum size of 2!");
        }
        double avgX = 0.0;
        double avgY = 0.0;
        int pairs = 0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            avgX += x[i];
            avgY += y[i];
            ++pairs;
        }
        if (pairs == 0) {
            return 0.0;
        }
        avgX /= (double)pairs;
        avgY /= (double)pairs;
        double varianceX = 0.0;
        double varianceY = 0.0;
        double covarianceXY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            double tempX = x[i] - avgX;
            varianceX += tempX * tempX;
            double tempY = y[i] - avgY;
            varianceY += tempY * tempY;
            covarianceXY += tempX * tempY;
        }
        if (varianceX == 0.0) {
            if (varianceY == 0.0) {
                return 1.0;
            }
            return 0.0;
        }
        if (varianceY == 0.0) {
            return 0.0;
        }
        double corr = covarianceXY / (Math.sqrt(varianceX) * Math.sqrt(varianceY));
        return corr;
    }
}

