/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.evaluate.correlation;

import java.util.Arrays;
import java.util.Comparator;
import org.aksw.palmetto.evaluate.correlation.RankCorrelationCalculator;

public class KendallsTau
implements RankCorrelationCalculator,
Comparator<ValuePair> {
    @Override
    public double calculateRankCorrelation(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("The x and y array must have the same size!");
        }
        ValuePair[] pairs = new ValuePair[x.length];
        for (int i = 0; i < x.length; ++i) {
            pairs[i] = new ValuePair(x[i], y[i]);
        }
        Arrays.sort(pairs, this);
        return this.calculateRankCorrelation(pairs);
    }

    protected double calculateRankCorrelation(ValuePair[] pairs) {
        double concordance = 0.0;
        double disconcordance = 0.0;
        double boundInX = 0.0;
        double boundInY = 0.0;
        for (int i = 0; i < pairs.length; ++i) {
            double currentX = pairs[i].first;
            double currentY = pairs[i].second;
            for (int j = i + 1; j < pairs.length; ++j) {
                if (pairs[j].first > currentX) {
                    if (pairs[j].second > currentY) {
                        concordance += 1.0;
                        continue;
                    }
                    if (pairs[j].second < currentY) {
                        disconcordance += 1.0;
                        continue;
                    }
                    boundInY += 1.0;
                    continue;
                }
                if (pairs[j].second == currentY) continue;
                boundInX += 1.0;
            }
        }
        if (concordance + disconcordance + boundInX == 0.0 || concordance + disconcordance + boundInY == 0.0) {
            return 0.0;
        }
        return (concordance - disconcordance) / Math.sqrt((concordance + disconcordance + boundInX) * (concordance + disconcordance + boundInY));
    }

    @Override
    public int compare(ValuePair pair1, ValuePair pair2) {
        double diff = pair1.first - pair2.first;
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        return 0;
    }

    protected static class ValuePair
    implements Comparable<ValuePair> {
        public double first;
        public double second;

        public ValuePair(double first, double second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compareTo(ValuePair v) {
            double diff = this.first - v.first;
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "(" + this.first + "|" + this.second + ")";
        }
    }
}

