/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene.creation;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.aksw.palmetto.corpus.lucene.SimpleAnalyzer;
import org.aksw.palmetto.corpus.lucene.creation.AbstractLuceneIndexCreator;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLuceneIndexCreator
extends AbstractLuceneIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLuceneIndexCreator.class);

    public SimpleLuceneIndexCreator(String fieldName) {
        super(fieldName);
    }

    public SimpleLuceneIndexCreator(String textFieldName, int commitInterval) {
        super(textFieldName, commitInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(File indexPath, Iterator<String> docIterator) {
        LOGGER.info("Starting index creation...");
        IndexWriter writer = null;
        indexPath.mkdirs();
        SimpleAnalyzer analyzer = new SimpleAnalyzer(true);
        try {
            IndexWriterConfig config = new IndexWriterConfig(version, analyzer);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            FieldType fieldType = new FieldType(TextField.TYPE_NOT_STORED);
            fieldType.setIndexed(true);
            fieldType.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS);
            fieldType.freeze();
            writer = new IndexWriter(FSDirectory.open(indexPath), config);
            int count = 0;
            while (docIterator.hasNext()) {
                String text = docIterator.next();
                if (text.length() > 0) {
                    writer.addDocument(this.toLuceneDocument(analyzer, text, fieldType));
                    if (++count < this.commitInterval) continue;
                    writer.commit();
                    System.gc();
                    count = 0;
                    continue;
                }
                LOGGER.warn("Got a document without content.");
            }
            LOGGER.info("Finished index creation.");
        }
        catch (IOException e) {
            LOGGER.error("Error while creating Index. Aborting.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return true;
    }
}

