/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene.creation;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.aksw.palmetto.corpus.lucene.SimpleAnalyzer;
import org.aksw.palmetto.corpus.lucene.creation.AbstractLuceneIndexCreator;
import org.aksw.palmetto.corpus.lucene.creation.IndexableDocument;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionStoringLuceneIndexCreator
extends AbstractLuceneIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionStoringLuceneIndexCreator.class);
    protected String docLengthFieldName;

    public PositionStoringLuceneIndexCreator(String textFieldName, String docLengthFieldName) {
        super(textFieldName);
        this.docLengthFieldName = docLengthFieldName;
    }

    public PositionStoringLuceneIndexCreator(String textFieldName, String docLengthFieldName, int commitInterval) {
        super(textFieldName, commitInterval);
        this.docLengthFieldName = docLengthFieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(File indexPath, Iterator<IndexableDocument> docIterator) {
        LOGGER.info("Starting index creation...");
        IndexWriter writer = null;
        indexPath.mkdirs();
        SimpleAnalyzer analyzer = new SimpleAnalyzer(true);
        try {
            IndexWriterConfig config = new IndexWriterConfig(version, analyzer);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            FieldType fieldType = new FieldType(TextField.TYPE_NOT_STORED);
            fieldType.setIndexed(true);
            fieldType.setStoreTermVectors(true);
            fieldType.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            fieldType.freeze();
            FieldType docLengthFieldType = new FieldType(IntField.TYPE_STORED);
            docLengthFieldType.setIndexed(false);
            docLengthFieldType.freeze();
            writer = new IndexWriter(FSDirectory.open(indexPath), config);
            int count = 0;
            while (docIterator.hasNext()) {
                IndexableDocument currentDocument = docIterator.next();
                if (currentDocument.getText().length() <= 0) continue;
                Document indexDocument = this.toLuceneDocument(analyzer, currentDocument.getText(), fieldType);
                this.addDocumentLength(indexDocument, this.docLengthFieldName, docLengthFieldType, currentDocument.getNumberOfTokens());
                writer.addDocument(indexDocument);
                if (++count < this.commitInterval) continue;
                writer.commit();
                System.gc();
                count = 0;
            }
            LOGGER.info("Finished index creation.");
        }
        catch (IOException e) {
            LOGGER.error("Error while creating Index. Aborting.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return true;
    }
}

