/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene.creation;

import com.carrotsearch.hppc.IntIntOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.SimpleFSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexHistogramCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexHistogramCreator.class);
    private String docLengthFieldName;

    public LuceneIndexHistogramCreator(String docLengthFieldName) {
        this.docLengthFieldName = docLengthFieldName;
    }

    public void createLuceneIndexHistogram(String indexPath) {
        int[][] histogram = this.createHistogram(indexPath);
        if (histogram != null) {
            this.storeHistogram(histogram, indexPath + ".histogram");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[][] createHistogram(String indexPath) {
        IntIntOpenHashMap histogram = new IntIntOpenHashMap();
        IndexReader dirReader = null;
        try {
            dirReader = DirectoryReader.open(new SimpleFSDirectory(new File(indexPath)));
            List<AtomicReaderContext> leaves = dirReader.leaves();
            int documentCount = 0;
            for (int i = 0; i < leaves.size(); ++i) {
                AtomicReader reader = leaves.get(i).reader();
                for (int d = 0; d < reader.maxDoc(); ++d) {
                    Integer number;
                    IndexableField field = reader.document(d).getField(this.docLengthFieldName);
                    if (field == null || (number = Integer.valueOf(field.numericValue().intValue())) == null) continue;
                    ++documentCount;
                    histogram.putOrAdd(number, 1, 1);
                }
            }
            LOGGER.info("Saw " + documentCount + " documents.");
        }
        catch (IOException e) {
            LOGGER.error("Error while reading from index. Returning null.");
            int[][] reader = null;
            return reader;
        }
        finally {
            if (dirReader != null) {
                try {
                    dirReader.close();
                }
                catch (IOException e) {}
            }
        }
        int[][] result = new int[histogram.size()][2];
        int posInResult = 0;
        long completeSum = 0L;
        for (int i = 0; i < histogram.keys.length; ++i) {
            if (!histogram.allocated[i]) continue;
            result[posInResult][0] = histogram.keys[i];
            result[posInResult][1] = histogram.values[i];
            completeSum += (long)(result[posInResult][0] * result[posInResult][1]);
            ++posInResult;
        }
        LOGGER.info("Counted " + completeSum + " tokens.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeHistogram(int[][] histogram, String filename) {
        File file = new File(filename);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fout = null;
        ObjectOutputStream oout = null;
        try {
            fout = new FileOutputStream(filename);
            oout = new ObjectOutputStream(fout);
            oout.writeObject(histogram);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't store histogram.");
        }
        finally {
            try {
                oout.close();
            }
            catch (Exception e) {}
            try {
                fout.close();
            }
            catch (Exception e) {}
        }
    }
}

