/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene.creation;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.util.Version;

public abstract class AbstractLuceneIndexCreator {
    protected static final Version version = Version.LUCENE_44;
    protected static final int DEFAULT_COMMIT_INTERVAL = 1000;
    protected String textFieldName;
    protected int commitInterval;

    public AbstractLuceneIndexCreator(String textFieldName) {
        this(textFieldName, 1000);
    }

    public AbstractLuceneIndexCreator(String textFieldName, int commitInterval) {
        this.textFieldName = textFieldName;
        this.commitInterval = commitInterval;
    }

    protected Document toLuceneDocument(Analyzer analyzer, String text, FieldType fieldType) throws IOException {
        Document document = new Document();
        document.add(new Field(this.textFieldName, analyzer.tokenStream(this.textFieldName, new StringReader(text)), fieldType));
        return document;
    }

    protected void addDocumentLength(Document document, String docLengthFieldName, FieldType docLengthFieldType, int documentLength) {
        document.add(new IntField(docLengthFieldName, documentLength, docLengthFieldType));
    }

    public int getCommitInterval() {
        return this.commitInterval;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public String getTextFieldName() {
        return this.textFieldName;
    }
}

