/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.aksw.palmetto.corpus.WindowSupportingAdapter;
import org.aksw.palmetto.corpus.lucene.LuceneCorpusAdapter;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.SimpleFSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowSupportingLuceneCorpusAdapter
extends LuceneCorpusAdapter
implements WindowSupportingAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowSupportingLuceneCorpusAdapter.class);
    public static final String HISTOGRAM_FILE_SUFFIX = ".histogram";
    protected int[][] histogram;
    protected String docLengthFieldName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowSupportingLuceneCorpusAdapter create(String indexPath, String textFieldName, String docLengthFieldName) throws CorruptIndexException, IOException {
        DirectoryReader dirReader = DirectoryReader.open(new SimpleFSDirectory(new File(indexPath)));
        List<AtomicReaderContext> leaves = dirReader.leaves();
        AtomicReader[] reader = new AtomicReader[leaves.size()];
        AtomicReaderContext[] contexts = new AtomicReaderContext[leaves.size()];
        for (int i = 0; i < reader.length; ++i) {
            contexts[i] = leaves.get(i);
            reader[i] = contexts[i].reader();
        }
        int[][] histogram = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(indexPath + HISTOGRAM_FILE_SUFFIX);
            ois = new ObjectInputStream(fis);
            histogram = (int[][])ois.readObject();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't read histogram file. Returning null.", e);
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Exception e) {}
        }
        if (histogram == null) {
            return null;
        }
        return new WindowSupportingLuceneCorpusAdapter(dirReader, reader, contexts, textFieldName, docLengthFieldName, histogram);
    }

    protected WindowSupportingLuceneCorpusAdapter(DirectoryReader dirReader, AtomicReader[] reader, AtomicReaderContext[] contexts, String textFieldName, String docLengthFieldName, int[][] histogram) {
        super(dirReader, reader, contexts, textFieldName);
        this.histogram = histogram;
        this.docLengthFieldName = docLengthFieldName;
    }

    @Override
    public int[][] getDocumentSizeHistogram() {
        return this.histogram;
    }

    @Override
    public IntObjectOpenHashMap<IntArrayList[]> requestWordPositionsInDocuments(String[] words, IntIntOpenHashMap docLengths) {
        IntObjectOpenHashMap<IntArrayList[]> positionsInDocs = new IntObjectOpenHashMap<IntArrayList[]>();
        for (int i = 0; i < words.length; ++i) {
            this.requestDocumentsWithWord(words[i], positionsInDocs, docLengths, i, words.length);
        }
        return positionsInDocs;
    }

    protected void requestDocumentsWithWord(String word, IntObjectOpenHashMap<IntArrayList[]> positionsInDocs, IntIntOpenHashMap docLengths, int wordId, int numberOfWords) {
        DocsAndPositionsEnum docPosEnum = null;
        Term term = new Term(this.fieldName, word);
        try {
            for (int i = 0; i < this.reader.length; ++i) {
                docPosEnum = this.reader[i].termPositionsEnum(term);
                int baseDocId = this.contexts[i].docBase;
                if (docPosEnum == null) continue;
                while (docPosEnum.nextDoc() != Integer.MAX_VALUE) {
                    IntArrayList[] positions;
                    int localDocId = docPosEnum.docID();
                    int globalDocId = localDocId + baseDocId;
                    if (!positionsInDocs.containsKey(globalDocId)) {
                        positions = new IntArrayList[numberOfWords];
                        positionsInDocs.put(globalDocId, positions);
                    } else {
                        positions = positionsInDocs.get(globalDocId);
                    }
                    if (positions[wordId] == null) {
                        positions[wordId] = new IntArrayList();
                    }
                    for (int p = 0; p < docPosEnum.freq(); ++p) {
                        positions[wordId].add(docPosEnum.nextPosition());
                    }
                    if (docLengths.containsKey(globalDocId)) continue;
                    docLengths.put(globalDocId, this.reader[i].document(localDocId).getField(this.docLengthFieldName).numericValue().intValue());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while requesting documents for word \"" + word + "\".", e);
        }
    }
}

