/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene;

import java.io.Reader;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import org.apache.lucene.util.Version;

public class SimpleAnalyzer
extends Analyzer {
    private static final Version version = Version.LUCENE_44;
    private static final String PATTERN = "([^\\p{Punct}\\p{Space}]+([\\p{Punct}][^\\p{Punct}\\p{Space}]+)*)";
    private PatternTokenizerFactory tokenizerFactory;
    private LowerCaseFilterFactory lowerCaseFilterFactory;

    public SimpleAnalyzer(boolean lowerCase) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("pattern", PATTERN);
        parameters.put("group", "0");
        parameters.put("luceneMatchVersion", version.name());
        this.tokenizerFactory = new PatternTokenizerFactory(parameters);
        if (lowerCase) {
            parameters = new HashMap();
            parameters.put("luceneMatchVersion", version.name());
            this.lowerCaseFilterFactory = new LowerCaseFilterFactory(parameters);
        } else {
            this.lowerCaseFilterFactory = null;
        }
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        Tokenizer tokenizer = this.tokenizerFactory.create(reader);
        if (this.lowerCaseFilterFactory != null) {
            return new Analyzer.TokenStreamComponents(tokenizer, this.lowerCaseFilterFactory.create(tokenizer));
        }
        return new Analyzer.TokenStreamComponents(tokenizer);
    }
}

