/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.corpus.lucene;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.ObjectObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.aksw.palmetto.corpus.BooleanDocumentSupportingAdapter;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.SimpleFSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneCorpusAdapter
implements BooleanDocumentSupportingAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneCorpusAdapter.class);
    protected String fieldName;
    protected DirectoryReader dirReader;
    protected AtomicReader[] reader;
    protected AtomicReaderContext[] contexts;

    public static LuceneCorpusAdapter create(String indexPath, String fieldName) throws CorruptIndexException, IOException {
        DirectoryReader dirReader = DirectoryReader.open(new SimpleFSDirectory(new File(indexPath)));
        List<AtomicReaderContext> leaves = dirReader.leaves();
        AtomicReader[] reader = new AtomicReader[leaves.size()];
        AtomicReaderContext[] contexts = new AtomicReaderContext[leaves.size()];
        for (int i = 0; i < reader.length; ++i) {
            contexts[i] = leaves.get(i);
            reader[i] = contexts[i].reader();
        }
        return new LuceneCorpusAdapter(dirReader, reader, contexts, fieldName);
    }

    protected LuceneCorpusAdapter(DirectoryReader dirReader, AtomicReader[] reader, AtomicReaderContext[] contexts, String fieldName) {
        this.dirReader = dirReader;
        this.reader = reader;
        this.contexts = contexts;
        this.fieldName = fieldName;
    }

    private void requestDocumentsWithWordAsSet(String word, IntOpenHashSet documents) {
        DocsEnum docs = null;
        Term term = new Term(this.fieldName, word);
        try {
            for (int i = 0; i < this.reader.length; ++i) {
                docs = this.reader[i].termDocsEnum(term);
                int baseDocId = this.contexts[i].docBase;
                if (docs == null) continue;
                while (docs.nextDoc() != Integer.MAX_VALUE) {
                    documents.add(baseDocId + docs.docID());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while requesting documents for word \"" + word + "\".", e);
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.reader.length; ++i) {
            try {
                this.reader[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getNumberOfDocuments() {
        try {
            int numDocs = this.dirReader.getDocCount(this.fieldName);
            if (numDocs < 0) {
                LOGGER.warn("Coudln't get the number of documents with the indexed field \"" + this.fieldName + "\". Using the number of all documents in the index instead.");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Coudln't get the number of documents with the indexed field \"" + this.fieldName + "\". Using the number of all documents in the index instead.", e);
        }
        return this.dirReader.numDocs();
    }

    @Override
    public void getDocumentsWithWordsAsSet(ObjectObjectOpenHashMap<String, IntOpenHashSet> wordDocMapping) {
        KType[] keys = wordDocMapping.keys;
        VType[] values = wordDocMapping.values;
        for (int i = 0; i < wordDocMapping.allocated.length; ++i) {
            if (!wordDocMapping.allocated[i]) continue;
            this.requestDocumentsWithWordAsSet((String)keys[i], (IntOpenHashSet)values[i]);
        }
    }

    @Override
    public void getDocumentsWithWords(ObjectObjectOpenHashMap<String, IntArrayList> wordDocMapping) {
        KType[] keys = wordDocMapping.keys;
        VType[] values = wordDocMapping.values;
        for (int i = 0; i < wordDocMapping.allocated.length; ++i) {
            if (!wordDocMapping.allocated[i]) continue;
            this.requestDocumentsWithWord((String)keys[i], (IntArrayList)values[i]);
        }
    }

    private void requestDocumentsWithWord(String word, IntArrayList documents) {
        DocsEnum docs = null;
        Term term = new Term(this.fieldName, word);
        try {
            for (int i = 0; i < this.reader.length; ++i) {
                docs = this.reader[i].termDocsEnum(term);
                int baseDocId = this.contexts[i].docBase;
                if (docs == null) continue;
                while (docs.nextDoc() != Integer.MAX_VALUE) {
                    documents.add(docs.docID() + baseDocId);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while requesting documents for word \"" + word + "\".", e);
        }
    }
}

