/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.calculations.indirect;

import org.aksw.palmetto.calculations.indirect.AbstractVectorBasedCalculation;

public class CosinusConfirmationMeasure
extends AbstractVectorBasedCalculation {
    @Override
    public String getName() {
        return "m_cos";
    }

    @Override
    protected double calculateSimilarity(double[] vector1, double[] vector2) {
        double length1 = 0.0;
        double length2 = 0.0;
        double sum = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            sum += vector1[i] * vector2[i];
            length1 += Math.pow(vector1[i], 2.0);
            length2 += Math.pow(vector2[i], 2.0);
        }
        if (length1 > 0.0 && length2 > 0.0) {
            return sum / (Math.sqrt(length1) * Math.sqrt(length2));
        }
        if (length1 == 0.0 && length2 == 0.0) {
            return 1.0;
        }
        return 0.0;
    }
}

