/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.calculations.indirect;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import org.aksw.palmetto.calculations.indirect.VectorBasedConfirmationMeasure;
import org.aksw.palmetto.data.SubsetVectors;

public abstract class AbstractVectorBasedCalculation
implements VectorBasedConfirmationMeasure {
    @Override
    public double[] calculateConfirmationValues(SubsetVectors subsetVectors) {
        int pos = 0;
        for (int i = 0; i < subsetVectors.segments.length; ++i) {
            pos += subsetVectors.conditions[i].length;
        }
        double[] values = new double[pos];
        IntObjectOpenHashMap<double[]> vectorCache = new IntObjectOpenHashMap<double[]>();
        for (int i = 0; i < subsetVectors.vectors.length; ++i) {
            vectorCache.put(1 << i, subsetVectors.vectors[i]);
        }
        pos = 0;
        for (int i = 0; i < subsetVectors.segments.length; ++i) {
            double[] segmentVector;
            if (vectorCache.containsKey(subsetVectors.segments[i])) {
                segmentVector = (double[])vectorCache.lget();
            } else {
                segmentVector = this.createVector(subsetVectors.segments[i], subsetVectors.vectors);
                vectorCache.put(subsetVectors.segments[i], segmentVector);
            }
            for (int j = 0; j < subsetVectors.conditions[i].length; ++j) {
                double[] conditionVector;
                if (vectorCache.containsKey(subsetVectors.conditions[i][j])) {
                    conditionVector = (double[])vectorCache.lget();
                } else {
                    conditionVector = this.createVector(subsetVectors.conditions[i][j], subsetVectors.vectors);
                    vectorCache.put(subsetVectors.conditions[i][j], conditionVector);
                }
                values[pos] = this.calculateSimilarity(segmentVector, conditionVector);
                ++pos;
            }
        }
        return values;
    }

    protected abstract double calculateSimilarity(double[] var1, double[] var2);

    protected double[] createVector(int id, double[][] vectors) {
        int vectorCount = Integer.bitCount(id);
        if (vectorCount == 1) {
            for (int i = 0; i < vectors.length; ++i) {
                if ((1 << i & id) <= 0) continue;
                return vectors[i];
            }
        } else {
            double[][] vectorSummands = new double[vectorCount][];
            int pos = 0;
            for (int i = 0; i < vectors.length; ++i) {
                if ((1 << i & id) <= 0) continue;
                vectorSummands[pos] = vectors[i];
                ++pos;
            }
            double[] vector = new double[vectorSummands[0].length];
            for (int i = 0; i < vector.length; ++i) {
                for (int j = 0; j < vectorSummands.length; ++j) {
                    int n = i;
                    vector[n] = vector[n] + vectorSummands[j][i];
                }
            }
            return vector;
        }
        return null;
    }
}

