/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.calculations.direct;

import org.aksw.palmetto.calculations.direct.AbstractUndefinedResultHandlingConfirmationMeasure;
import org.aksw.palmetto.data.SubsetProbabilities;

public class OlssonsConfirmationMeasure
extends AbstractUndefinedResultHandlingConfirmationMeasure {
    public OlssonsConfirmationMeasure() {
    }

    public OlssonsConfirmationMeasure(double resultIfCalcUndefined) {
        super(resultIfCalcUndefined);
    }

    @Override
    public double[] calculateConfirmationValues(SubsetProbabilities subsetProbabilities) {
        int pos = 0;
        for (int i = 0; i < subsetProbabilities.segments.length; ++i) {
            pos += subsetProbabilities.conditions[i].length;
        }
        double[] values = new double[pos];
        pos = 0;
        for (int i = 0; i < subsetProbabilities.segments.length; ++i) {
            for (int j = 0; j < subsetProbabilities.conditions[i].length; ++j) {
                double intersectionProbability = subsetProbabilities.probabilities[subsetProbabilities.segments[i] | subsetProbabilities.conditions[i][j]];
                double jointProbability = this.determineJointProbability(subsetProbabilities.segments[i] | subsetProbabilities.conditions[i][j], subsetProbabilities.probabilities);
                values[pos] = jointProbability > 0.0 ? intersectionProbability / jointProbability : this.resultIfCalcUndefined;
                ++pos;
            }
        }
        return values;
    }

    private double determineJointProbability(int jointBits, double[] probabilities) {
        double jointProbability = 0.0;
        int inverseMask = ~jointBits;
        for (int i = 1; i <= jointBits; ++i) {
            if ((inverseMask & i) != 0) continue;
            if ((Integer.bitCount(i) & 1) == 0) {
                jointProbability -= probabilities[i];
                continue;
            }
            jointProbability += probabilities[i];
        }
        return jointProbability;
    }

    @Override
    public String getName() {
        return "m_o";
    }
}

