/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.calculations.direct;

import org.aksw.palmetto.calculations.direct.AbstractUndefinedResultHandlingConfirmationMeasure;
import org.aksw.palmetto.calculations.direct.LogBasedCalculation;
import org.aksw.palmetto.data.SubsetProbabilities;

public class LogRatioConfirmationMeasure
extends AbstractUndefinedResultHandlingConfirmationMeasure
implements LogBasedCalculation {
    public LogRatioConfirmationMeasure() {
    }

    public LogRatioConfirmationMeasure(double resultIfCalcUndefined) {
        super(resultIfCalcUndefined);
    }

    @Override
    public double[] calculateConfirmationValues(SubsetProbabilities subsetProbabilities) {
        int pos = 0;
        for (int i = 0; i < subsetProbabilities.segments.length; ++i) {
            pos += subsetProbabilities.conditions[i].length;
        }
        double[] values = new double[pos];
        pos = 0;
        for (int i = 0; i < subsetProbabilities.segments.length; ++i) {
            int j;
            double segmentProbability = subsetProbabilities.probabilities[subsetProbabilities.segments[i]];
            if (segmentProbability > 0.0) {
                for (j = 0; j < subsetProbabilities.conditions[i].length; ++j) {
                    double conditionProbability = subsetProbabilities.probabilities[subsetProbabilities.conditions[i][j]];
                    double intersectionProbability = subsetProbabilities.probabilities[subsetProbabilities.segments[i] | subsetProbabilities.conditions[i][j]];
                    values[pos] = conditionProbability > 0.0 ? Math.log((intersectionProbability + 1.0E-12) / (segmentProbability * conditionProbability)) : this.resultIfCalcUndefined;
                    ++pos;
                }
                continue;
            }
            for (j = 0; j < subsetProbabilities.conditions[i].length; ++j) {
                values[pos] = this.resultIfCalcUndefined;
                ++pos;
            }
        }
        return values;
    }

    @Override
    public String getName() {
        return "m_lr";
    }
}

