/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.calculations.direct;

import org.aksw.palmetto.calculations.direct.AbstractUndefinedResultHandlingConfirmationMeasure;
import org.aksw.palmetto.data.SubsetProbabilities;

public class FitelsonConfirmationMeasure
extends AbstractUndefinedResultHandlingConfirmationMeasure {
    public FitelsonConfirmationMeasure() {
    }

    public FitelsonConfirmationMeasure(double resultIfCalcUndefined) {
        super(resultIfCalcUndefined);
    }

    @Override
    public double[] calculateConfirmationValues(SubsetProbabilities subsetProbabilities) {
        int pos = 0;
        for (int i = 0; i < subsetProbabilities.segments.length; ++i) {
            pos += subsetProbabilities.conditions[i].length;
        }
        double[] values = new double[pos];
        pos = 0;
        for (int i = 0; i < subsetProbabilities.segments.length; ++i) {
            double segmentProbability = subsetProbabilities.probabilities[subsetProbabilities.segments[i]];
            for (int j = 0; j < subsetProbabilities.conditions[i].length; ++j) {
                double conditionProbability = subsetProbabilities.probabilities[subsetProbabilities.conditions[i][j]];
                double intersectionProbability = subsetProbabilities.probabilities[subsetProbabilities.segments[i] | subsetProbabilities.conditions[i][j]];
                double conditionalProbability = conditionProbability > 0.0 ? intersectionProbability / subsetProbabilities.probabilities[subsetProbabilities.conditions[i][j]] : 0.0;
                double otherCondProb = conditionProbability < 1.0 ? (segmentProbability - intersectionProbability) / (1.0 - conditionProbability) : 0.0;
                values[pos] = conditionalProbability > 0.0 || otherCondProb > 0.0 ? (conditionalProbability - otherCondProb) / (conditionalProbability + otherCondProb) : this.resultIfCalcUndefined;
                ++pos;
            }
        }
        return values;
    }

    @Override
    public String getName() {
        return "m_f";
    }
}

