/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.aggregation;

import org.aksw.palmetto.aggregation.Aggregation;

public class QuadraticMean
implements Aggregation {
    @Override
    public double summarize(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += Math.pow(values[i], 2.0);
        }
        return Math.sqrt(sum / (double)values.length);
    }

    @Override
    public String getName() {
        return "sigma_q";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public double summarize(double[] values, double[] weights) {
        double sum = 0.0;
        double weightSum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            sum += weights[i] * Math.pow(values[i], 2.0);
            weightSum += weights[i];
        }
        if (weightSum > 0.0) {
            return Math.sqrt(sum / weightSum);
        }
        return 0.0;
    }
}

