/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.aggregation;

import org.aksw.palmetto.aggregation.Aggregation;

public class Min
implements Aggregation {
    @Override
    public double summarize(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < min)) continue;
            min = values[i];
        }
        return min;
    }

    @Override
    public String getName() {
        return "sigma_n";
    }

    @Override
    public double summarize(double[] values, double[] weights) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            double value;
            if (Double.isNaN(values[i]) || !((value = values[i] * weights[i]) < min)) continue;
            min = value;
        }
        if (Double.isInfinite(min)) {
            return 0.0;
        }
        return min;
    }
}

