/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.aggregation;

import com.carrotsearch.hppc.DoubleArrayList;
import java.util.Arrays;
import org.aksw.palmetto.aggregation.Aggregation;

public class Median
implements Aggregation {
    @Override
    public double summarize(double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("The given array has to have at least one element to determine the modus.");
        }
        Arrays.sort(values);
        if ((values.length & 1) > 0) {
            return values[values.length / 2];
        }
        return (values[values.length / 2] + values[values.length / 2 - 1]) / 2.0;
    }

    @Override
    public String getName() {
        return "sigma_m";
    }

    @Override
    public double summarize(double[] values, double[] weights) {
        if (values.length == 0) {
            throw new IllegalArgumentException("The given array has to have at least one element to determine the modus.");
        }
        DoubleArrayList weightedValues = new DoubleArrayList(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            weightedValues.add(weights[i] * values[i]);
        }
        if (weightedValues.size() == 0) {
            return 0.0;
        }
        double[] weightedValuesAsArray = weightedValues.toArray();
        Arrays.sort(weightedValuesAsArray);
        if ((weightedValuesAsArray.length & 1) > 0) {
            return weightedValuesAsArray[weightedValuesAsArray.length / 2];
        }
        return (weightedValuesAsArray[weightedValuesAsArray.length / 2] + weightedValuesAsArray[weightedValuesAsArray.length / 2 - 1]) / 2.0;
    }
}

