/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.aggregation;

import org.aksw.palmetto.aggregation.Aggregation;

public class HarmonicMean
implements Aggregation {
    @Override
    public double summarize(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0.0) {
                return 0.0;
            }
            sum += 1.0 / values[i];
        }
        if (sum == 0.0) {
            return 0.0;
        }
        return (double)values.length / sum;
    }

    @Override
    public String getName() {
        return "sigma_h";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public double summarize(double[] values, double[] weights) {
        double weightSum = 0.0;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            if (values[i] == 0.0) {
                return 0.0;
            }
            sum += weights[i] / values[i];
            weightSum += weights[i];
        }
        if (sum == 0.0) {
            return 0.0;
        }
        return weightSum / sum;
    }
}

