/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.aggregation;

import org.aksw.palmetto.aggregation.Aggregation;

public class GeometricMean
implements Aggregation {
    @Override
    public double summarize(double[] values) {
        double prod = 1.0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] <= 0.0) {
                return 0.0;
            }
            prod *= values[i];
        }
        return Math.pow(prod, 1.0 / (double)values.length);
    }

    @Override
    public String getName() {
        return "sigma_g";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public double summarize(double[] values, double[] weights) {
        double weightSum = 0.0;
        double prod = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            if (values[i] <= 0.0) {
                return 0.0;
            }
            prod += weights[i] * Math.log(values[i]);
            weightSum += weights[i];
        }
        if (weightSum > 0.0) {
            return Math.exp(prod / weightSum);
        }
        return 0.0;
    }
}

