/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto.aggregation;

import org.aksw.palmetto.aggregation.Aggregation;

public class ArithmeticMean
implements Aggregation {
    @Override
    public double summarize(double[] values) {
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum / (double)values.length;
    }

    @Override
    public String getName() {
        return "sigma_a";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public double summarize(double[] values, double[] weights) {
        double weightSum = 0.0;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            sum += weights[i] * values[i];
            weightSum += weights[i];
        }
        if (weightSum > 0.0) {
            return sum / weightSum;
        }
        return 0.0;
    }
}

