/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto;

import org.aksw.palmetto.Coherence;
import org.aksw.palmetto.aggregation.Aggregation;
import org.aksw.palmetto.calculations.indirect.VectorBasedConfirmationMeasure;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.data.SubsetVectors;
import org.aksw.palmetto.subsets.Segmentator;
import org.aksw.palmetto.vector.VectorCreator;
import org.aksw.palmetto.weight.Weighter;

public class VectorBasedCoherence
implements Coherence {
    protected Segmentator segmentator;
    protected VectorCreator vectorCreator;
    protected VectorBasedConfirmationMeasure confirmation;
    protected Aggregation aggregation;
    @Deprecated
    protected Weighter weighter;

    @Deprecated
    public VectorBasedCoherence(Segmentator segmentator, VectorCreator vectorCreator, VectorBasedConfirmationMeasure confirmation, Aggregation aggregation, Weighter weighter) {
        this.segmentator = segmentator;
        this.vectorCreator = vectorCreator;
        this.confirmation = confirmation;
        this.aggregation = aggregation;
        this.weighter = weighter;
    }

    public VectorBasedCoherence(Segmentator segmentator, VectorCreator vectorCreator, VectorBasedConfirmationMeasure confirmation, Aggregation aggregation) {
        this.segmentator = segmentator;
        this.vectorCreator = vectorCreator;
        this.confirmation = confirmation;
        this.aggregation = aggregation;
    }

    @Override
    public double[] calculateCoherences(String[][] wordsets) {
        SegmentationDefinition[] definitions = new SegmentationDefinition[wordsets.length];
        for (int i = 0; i < definitions.length; ++i) {
            definitions[i] = this.segmentator.getSubsetDefinition(wordsets[i].length);
        }
        SubsetVectors[] vectors = this.vectorCreator.getVectors(wordsets, definitions);
        definitions = null;
        double[] coherences = new double[vectors.length];
        if (this.weighter != null) {
            for (int i = 0; i < vectors.length; ++i) {
                coherences[i] = this.aggregation.summarize(this.confirmation.calculateConfirmationValues(vectors[i]), this.weighter.createWeights(vectors[i]));
            }
        } else {
            for (int i = 0; i < vectors.length; ++i) {
                coherences[i] = this.aggregation.summarize(this.confirmation.calculateConfirmationValues(vectors[i]));
            }
        }
        return coherences;
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append("C(");
        builder.append(this.vectorCreator.getProbabilityEstimatorName());
        builder.append(',');
        builder.append(this.vectorCreator.getVectorSpaceName());
        builder.append(',');
        builder.append(this.vectorCreator.getVectorCreatorName());
        builder.append(',');
        builder.append(this.segmentator.getName());
        builder.append(',');
        builder.append(this.confirmation.getName());
        builder.append(',');
        builder.append(this.aggregation.getName());
        if (this.weighter != null) {
            builder.append(',');
            builder.append(this.weighter.getName());
        }
        builder.append(')');
        return builder.toString();
    }
}

