/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.palmetto;

import org.aksw.palmetto.Coherence;
import org.aksw.palmetto.aggregation.Aggregation;
import org.aksw.palmetto.calculations.direct.DirectConfirmationMeasure;
import org.aksw.palmetto.data.SegmentationDefinition;
import org.aksw.palmetto.data.SubsetProbabilities;
import org.aksw.palmetto.prob.ProbabilityEstimator;
import org.aksw.palmetto.subsets.Segmentator;
import org.aksw.palmetto.weight.Weighter;

public class DirectConfirmationBasedCoherence
implements Coherence {
    protected Segmentator segmentation;
    protected ProbabilityEstimator probEstimator;
    protected DirectConfirmationMeasure confirmation;
    protected Aggregation aggregation;
    @Deprecated
    protected Weighter weighter;

    @Deprecated
    public DirectConfirmationBasedCoherence(Segmentator segmentation, ProbabilityEstimator probEstimator, DirectConfirmationMeasure confirmation, Aggregation aggregation, Weighter weighter) {
        this.segmentation = segmentation;
        this.probEstimator = probEstimator;
        this.confirmation = confirmation;
        this.aggregation = aggregation;
        this.weighter = weighter;
    }

    public DirectConfirmationBasedCoherence(Segmentator segmentation, ProbabilityEstimator probEstimator, DirectConfirmationMeasure confirmation, Aggregation aggregation) {
        this.segmentation = segmentation;
        this.probEstimator = probEstimator;
        this.confirmation = confirmation;
        this.aggregation = aggregation;
    }

    @Override
    public double[] calculateCoherences(String[][] wordsets) {
        SegmentationDefinition[] definitions = new SegmentationDefinition[wordsets.length];
        for (int i = 0; i < definitions.length; ++i) {
            definitions[i] = this.segmentation.getSubsetDefinition(wordsets[i].length);
        }
        SubsetProbabilities[] probabilities = this.probEstimator.getProbabilities(wordsets, definitions);
        definitions = null;
        double[] coherences = new double[probabilities.length];
        if (this.weighter != null) {
            for (int i = 0; i < probabilities.length; ++i) {
                coherences[i] = this.aggregation.summarize(this.confirmation.calculateConfirmationValues(probabilities[i]), this.weighter.createWeights(probabilities[i]));
            }
        } else {
            for (int i = 0; i < probabilities.length; ++i) {
                coherences[i] = this.aggregation.summarize(this.confirmation.calculateConfirmationValues(probabilities[i]));
            }
        }
        return coherences;
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append("C(");
        builder.append(this.probEstimator.getName());
        builder.append(',');
        builder.append(this.segmentation.getName());
        builder.append(',');
        builder.append(this.confirmation.getName());
        builder.append(',');
        builder.append(this.aggregation.getName());
        if (this.weighter != null) {
            builder.append(',');
            builder.append(this.weighter.getName());
        }
        builder.append(')');
        return builder.toString();
    }
}

