/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteFunction;
import gnu.trove.TByteProcedure;
import gnu.trove.TShortByteIterator;
import gnu.trove.TShortByteProcedure;
import gnu.trove.TShortHash;
import gnu.trove.TShortHashingStrategy;
import gnu.trove.TShortProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class TShortByteHashMap
extends TShortHash
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected transient byte[] _values;

    public TShortByteHashMap() {
    }

    public TShortByteHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TShortByteHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TShortByteHashMap(TShortHashingStrategy strategy) {
        super(strategy);
    }

    public TShortByteHashMap(int initialCapacity, TShortHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TShortByteHashMap(int initialCapacity, float loadFactor, TShortHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TShortByteHashMap m = (TShortByteHashMap)super.clone();
        m._values = (byte[])this._values.clone();
        return m;
    }

    public TShortByteIterator iterator() {
        return new TShortByteIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new byte[capacity];
        return capacity;
    }

    public byte put(short key, byte value) {
        byte previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        short[] oldKeys = this._set;
        byte[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new short[newCapacity];
        this._values = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            short o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public byte get(short key) {
        int index = this.index(key);
        return index < 0 ? (byte)0 : this._values[index];
    }

    public void clear() {
        super.clear();
        short[] keys = this._set;
        byte[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public byte remove(short key) {
        byte prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TShortByteHashMap)) {
            return false;
        }
        TShortByteHashMap that = (TShortByteHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0;
        super.removeAt(index);
    }

    public byte[] getValues() {
        byte[] vals = new byte[this.size()];
        byte[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public short[] keys() {
        short[] keys = new short[this.size()];
        short[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public short[] keys(short[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (short[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        short[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == 0 || k[i] == 2) continue;
            a[j++] = k[i];
        }
        return a;
    }

    public boolean containsValue(byte val) {
        byte[] states = this._states;
        byte[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(short key) {
        return this.contains(key);
    }

    public boolean forEachKey(TShortProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TShortByteProcedure procedure) {
        byte[] states = this._states;
        short[] keys = this._set;
        byte[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TShortByteProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        short[] keys = this._set;
        byte[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public void transformValues(TByteFunction function) {
        byte[] states = this._states;
        byte[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(short key) {
        return this.adjustValue(key, (byte)1);
    }

    public boolean adjustValue(short key, byte amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = (byte)(this._values[n] + amount);
        return true;
    }

    public byte adjustOrPutValue(short key, byte adjust_amount, byte put_amount) {
        boolean isNewMapping;
        byte newValue;
        int index = this.insertionIndex(key);
        if (index < 0) {
            int n = index = -index - 1;
            byte by = (byte)(this._values[n] + adjust_amount);
            this._values[n] = by;
            newValue = by;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return newValue;
    }

    public void writeExternal(ObjectOutput out2) throws IOException {
        out2.writeByte(0);
        out2.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out2);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            short key = in.readShort();
            byte val = in.readByte();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TShortByteProcedure {
        private final TShortByteHashMap _otherMap;

        EqProcedure(TShortByteHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(short key, byte value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(byte v1, byte v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TShortByteProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(short key, byte value) {
            this.h += TShortByteHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

