/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.logging.PrettyLoggable;
import edu.stanford.nlp.util.logging.PrettyLogger;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class Pair<T1, T2>
implements Comparable<Pair<T1, T2>>,
Serializable,
PrettyLoggable {
    public T1 first;
    public T2 second;
    private static final long serialVersionUID = 1360822168806852921L;

    public Pair() {
    }

    public Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public void setFirst(T1 o) {
        this.first = o;
    }

    public void setSecond(T2 o) {
        this.second = o;
    }

    public String toString() {
        return "(" + this.first + "," + this.second + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair p = (Pair)o;
            return (this.first == null ? p.first() == null : this.first.equals(p.first())) && (this.second == null ? p.second() == null : this.second.equals(p.second()));
        }
        return false;
    }

    public int hashCode() {
        int firstHash = this.first == null ? 0 : this.first.hashCode();
        int secondHash = this.second == null ? 0 : this.second.hashCode();
        return firstHash * 31 + secondHash;
    }

    public List<Object> asList() {
        return CollectionUtils.makeList(this.first, this.second);
    }

    public static Pair<String, String> readStringPair(DataInputStream in) {
        Pair<String, String> p = new Pair<String, String>();
        try {
            p.first = in.readUTF();
            p.second = in.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static <X, Y> Pair<X, Y> makePair(X x, Y y) {
        return new Pair<X, Y>(x, y);
    }

    public void save(DataOutputStream out2) {
        try {
            out2.writeUTF(this.first.toString());
            out2.writeUTF(this.second.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int compareTo(Pair<T1, T2> another) {
        int comp;
        if (this.first() instanceof Comparable && (comp = ((Comparable)this.first()).compareTo(another.first())) != 0) {
            return comp;
        }
        if (this.second() instanceof Comparable) {
            return ((Comparable)this.second()).compareTo(another.second());
        }
        if (!(this.first() instanceof Comparable) && !(this.second() instanceof Comparable)) {
            throw new AssertionError((Object)"Neither element of pair comparable");
        }
        return 0;
    }

    public static Pair<String, String> stringIntern(Pair<String, String> p) {
        return new MutableInternedPair(p);
    }

    public static Pair<String, String> internedStringPair(String first, String second) {
        return new MutableInternedPair(first, second);
    }

    @Override
    public void prettyLog(Redwood.RedwoodChannels channels, String description) {
        PrettyLogger.log(channels, description, this.asList());
    }

    public static class BySecondReversePairComparator<T1, T2>
    implements Comparator<Pair<T1, T2>> {
        @Override
        public int compare(Pair<T1, T2> pair1, Pair<T1, T2> pair2) {
            return -((Comparable)pair1.second()).compareTo(pair2.second());
        }
    }

    public static class BySecondPairComparator<T1, T2>
    implements Comparator<Pair<T1, T2>> {
        @Override
        public int compare(Pair<T1, T2> pair1, Pair<T1, T2> pair2) {
            return ((Comparable)pair1.second()).compareTo(pair2.second());
        }
    }

    public static class ByFirstReversePairComparator<T1, T2>
    implements Comparator<Pair<T1, T2>> {
        @Override
        public int compare(Pair<T1, T2> pair1, Pair<T1, T2> pair2) {
            return -((Comparable)pair1.first()).compareTo(pair2.first());
        }
    }

    public static class ByFirstPairComparator<T1, T2>
    implements Comparator<Pair<T1, T2>> {
        @Override
        public int compare(Pair<T1, T2> pair1, Pair<T1, T2> pair2) {
            return ((Comparable)pair1.first()).compareTo(pair2.first());
        }
    }

    static class MutableInternedPair
    extends Pair<String, String> {
        private static final long serialVersionUID = 1360822168806852922L;

        private MutableInternedPair(Pair<String, String> p) {
            super(p.first, p.second);
            this.internStrings();
        }

        private MutableInternedPair(String first, String second) {
            super(first, second);
            this.internStrings();
        }

        protected Object readResolve() {
            this.internStrings();
            return this;
        }

        private void internStrings() {
            if (this.first != null) {
                this.first = ((String)this.first).intern();
            }
            if (this.second != null) {
                this.second = ((String)this.second).intern();
            }
        }
    }
}

