/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.CompoundUnaryTransition;
import edu.stanford.nlp.parser.shiftreduce.FinalizeTransition;
import edu.stanford.nlp.parser.shiftreduce.IdleTransition;
import edu.stanford.nlp.parser.shiftreduce.OracleTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class Oracle {
    List<Tree> binarizedTrees;
    List<IdentityHashMap<Tree, Tree>> parentMaps;
    List<List<Tree>> leafLists;
    boolean compoundUnaries;

    Oracle(List<Tree> binarizedTrees, boolean compoundUnaries) {
        this.binarizedTrees = binarizedTrees;
        this.parentMaps = Generics.newArrayList(binarizedTrees.size());
        this.leafLists = Generics.newArrayList();
        for (Tree tree : binarizedTrees) {
            this.parentMaps.add(Oracle.buildParentMap(tree));
            this.leafLists.add(Trees.leaves(tree));
        }
        this.compoundUnaries = compoundUnaries;
    }

    static IdentityHashMap<Tree, Tree> buildParentMap(Tree tree) {
        IdentityHashMap<Tree, Tree> map = Generics.newIdentityHashMap();
        Oracle.buildParentMapHelper(tree, null, map);
        return map;
    }

    static void buildParentMapHelper(Tree tree, Tree parent, IdentityHashMap<Tree, Tree> map) {
        if (parent != null) {
            map.put(tree, parent);
        }
        if (!tree.isLeaf()) {
            for (Tree child : tree.children()) {
                Oracle.buildParentMapHelper(child, tree, map);
            }
        }
    }

    OracleTransition goldTransition(int index, State state) {
        Tree enclosingS0;
        if (state.finished) {
            return new OracleTransition(new IdleTransition(), false, false, false);
        }
        if (state.stack.size() == 0) {
            return new OracleTransition(new ShiftTransition(), false, false, false);
        }
        Map parents = this.parentMaps.get(index);
        Tree gold = this.binarizedTrees.get(index);
        List<Tree> leaves = this.leafLists.get(index);
        Tree S0 = state.stack.peek();
        OracleTransition result = Oracle.getUnaryTransition(S0, enclosingS0 = Oracle.getEnclosingTree(S0, parents, leaves), parents, this.compoundUnaries);
        if (result != null) {
            return result;
        }
        if (state.tokenPosition >= state.sentence.size() && state.stack.size() == 1) {
            return new OracleTransition(new FinalizeTransition(), false, false, false);
        }
        if (state.stack.size() == 1) {
            return new OracleTransition(new ShiftTransition(), false, false, false);
        }
        if (Oracle.spansEqual(S0, enclosingS0)) {
            Tree enclosingS1;
            Tree parent = (Tree)parents.get(enclosingS0);
            while (Oracle.spansEqual(parent, enclosingS0)) {
                enclosingS0 = parent;
                parent = (Tree)parents.get(parent);
            }
            if (parent.children()[0] == enclosingS0) {
                return new OracleTransition(new ShiftTransition(), false, false, false);
            }
            Tree S1 = state.stack.pop().peek();
            if (Oracle.spansEqual(S1, enclosingS1 = Oracle.getEnclosingTree(S1, parents, leaves))) {
                return new OracleTransition(new BinaryTransition(parent.value(), ShiftReduceUtils.getBinarySide(parent)), false, false, false);
            }
            return new OracleTransition(null, false, true, false);
        }
        if (ShiftReduceUtils.leftIndex(S0) == ShiftReduceUtils.leftIndex(enclosingS0)) {
            return new OracleTransition(new ShiftTransition(), false, false, false);
        }
        if (ShiftReduceUtils.rightIndex(S0) == ShiftReduceUtils.rightIndex(enclosingS0)) {
            Tree S1 = state.stack.pop().peek();
            Tree enclosingS1 = Oracle.getEnclosingTree(S1, parents, leaves);
            if (enclosingS0 == enclosingS1) {
                return new OracleTransition(new BinaryTransition(enclosingS0.value(), BinaryTransition.Side.LEFT), false, false, true);
            }
            if (ShiftReduceUtils.leftIndex(S1) > ShiftReduceUtils.leftIndex(enclosingS0)) {
                return new OracleTransition(null, false, true, true);
            }
            return new OracleTransition(null, true, true, true);
        }
        return new OracleTransition(null, true, true, true);
    }

    static Tree getEnclosingTree(Tree subtree, Map<Tree, Tree> parents, List<Tree> leaves) {
        int left = ShiftReduceUtils.leftIndex(subtree);
        int right = ShiftReduceUtils.rightIndex(subtree);
        Tree gold = leaves.get(left);
        while (ShiftReduceUtils.rightIndex(gold) < right) {
            gold = parents.get(gold);
        }
        if (gold.isLeaf()) {
            gold = parents.get(gold);
        }
        return gold;
    }

    static boolean spansEqual(Tree subtree, Tree goldSubtree) {
        return ShiftReduceUtils.leftIndex(subtree) == ShiftReduceUtils.leftIndex(goldSubtree) && ShiftReduceUtils.rightIndex(subtree) == ShiftReduceUtils.rightIndex(goldSubtree);
    }

    static OracleTransition getUnaryTransition(Tree S0, Tree enclosingS0, Map<Tree, Tree> parents, boolean compoundUnaries) {
        Tree parent;
        block9: {
            if (!Oracle.spansEqual(S0, enclosingS0)) {
                return null;
            }
            parent = parents.get(enclosingS0);
            if (parent == null || parent.children().length != 1) {
                return null;
            }
            String value = S0.value();
            if (!enclosingS0.value().equals(value)) {
                do {
                    enclosingS0 = parent;
                    parent = parents.get(enclosingS0);
                    if (enclosingS0.value().equals(value)) {
                        if (parent == null || parent.children().length > 1) {
                            return null;
                        }
                    } else {
                        if (parent != null) continue;
                        parent = enclosingS0;
                    }
                    break block9;
                } while (parent.children().length <= 1);
                parent = enclosingS0;
            }
        }
        if (compoundUnaries) {
            ArrayList<String> labels = Generics.newArrayList();
            while (parent != null && parent.children().length == 1) {
                labels.add(parent.value());
                parent = parents.get(parent);
            }
            Collections.reverse(labels);
            return new OracleTransition(new CompoundUnaryTransition(labels, false), false, false, false);
        }
        return new OracleTransition(new UnaryTransition(parent.value(), false), false, false, false);
    }
}

