/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.DiffFloatFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.FloatFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.HasRegularizerParamRange;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.util.Generics;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class QNMinimizer
implements Minimizer<DiffFunction>,
HasEvaluators {
    private int fevals = 0;
    private int maxFevals = -1;
    private int mem = 10;
    private int its = 0;
    private final Function monitor;
    private boolean quiet;
    private static final NumberFormat nf = new DecimalFormat("0.000E0");
    private static final NumberFormat nfsec = new DecimalFormat("0.00");
    private static final double ftol = 1.0E-4;
    private double gtol = 0.9;
    private static final double aMin = 1.0E-12;
    private static final double aMax = 1.0E12;
    private static final double p66 = 0.66;
    private static final double p5 = 0.5;
    private static final int a = 0;
    private static final int f = 1;
    private static final int g = 2;
    public boolean outputToFile = false;
    private boolean success = false;
    private boolean bracketed = false;
    private QNInfo presetInfo = null;
    private boolean noHistory = true;
    private boolean useOWLQN = false;
    private double lambdaOWL = 0.0;
    private boolean useAveImprovement = true;
    private boolean useRelativeNorm = true;
    private boolean useNumericalZero = true;
    private boolean useEvalImprovement = false;
    private boolean useMaxItr = false;
    private int maxItr = 0;
    private boolean suppressTestPrompt = false;
    private int terminateOnEvalImprovementNumOfEpoch = 1;
    private int evaluateIters = 0;
    private int startEvaluateIters = 0;
    private Evaluator[] evaluators;
    eLineSearch lsOpt = eLineSearch.MINPACK;
    eScaling scaleOpt = eScaling.DIAGONAL;
    eState state = eState.CONTINUE;

    public QNMinimizer() {
        this((Function)null);
    }

    public QNMinimizer(int m) {
        this(null, m);
    }

    public QNMinimizer(int m, boolean useRobustOptions) {
        this(null, m, useRobustOptions);
    }

    public QNMinimizer(Function monitor) {
        this.monitor = monitor;
    }

    public QNMinimizer(Function monitor, int m) {
        this(monitor, m, false);
    }

    public QNMinimizer(Function monitor, int m, boolean useRobustOptions) {
        this.monitor = monitor;
        this.mem = m;
        if (useRobustOptions) {
            this.setRobustOptions();
        }
    }

    public QNMinimizer(FloatFunction monitor) {
        throw new UnsupportedOperationException("Doesn't support floats yet");
    }

    public void setOldOptions() {
        this.useAveImprovement = true;
        this.useRelativeNorm = false;
        this.useNumericalZero = false;
        this.lsOpt = eLineSearch.BACKTRACK;
        this.scaleOpt = eScaling.SCALAR;
    }

    public final void setRobustOptions() {
        this.useAveImprovement = true;
        this.useRelativeNorm = true;
        this.useNumericalZero = true;
        this.lsOpt = eLineSearch.MINPACK;
        this.scaleOpt = eScaling.DIAGONAL;
    }

    @Override
    public void setEvaluators(int iters, Evaluator[] evaluators) {
        this.evaluateIters = iters;
        this.evaluators = evaluators;
    }

    public void setEvaluators(int iters, int startEvaluateIters, Evaluator[] evaluators) {
        this.evaluateIters = iters;
        this.startEvaluateIters = startEvaluateIters;
        this.evaluators = evaluators;
    }

    public void terminateOnRelativeNorm(boolean toTerminate) {
        this.useRelativeNorm = toTerminate;
    }

    public void terminateOnNumericalZero(boolean toTerminate) {
        this.useNumericalZero = toTerminate;
    }

    public void terminateOnAverageImprovement(boolean toTerminate) {
        this.useAveImprovement = toTerminate;
    }

    public void terminateOnEvalImprovement(boolean toTerminate) {
        this.useEvalImprovement = toTerminate;
    }

    public void terminateOnMaxItr(int maxItr) {
        if (maxItr > 0) {
            this.useMaxItr = true;
            this.maxItr = maxItr;
        }
    }

    public void suppressTestPrompt(boolean suppressTestPrompt) {
        this.suppressTestPrompt = suppressTestPrompt;
    }

    public void setTerminateOnEvalImprovementNumOfEpoch(int terminateOnEvalImprovementNumOfEpoch) {
        this.terminateOnEvalImprovementNumOfEpoch = terminateOnEvalImprovementNumOfEpoch;
    }

    public void useMinPackSearch() {
        this.lsOpt = eLineSearch.MINPACK;
    }

    public void useBacktracking() {
        this.lsOpt = eLineSearch.BACKTRACK;
    }

    public void useDiagonalScaling() {
        this.scaleOpt = eScaling.DIAGONAL;
    }

    public void useScalarScaling() {
        this.scaleOpt = eScaling.SCALAR;
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    public void shutUp() {
        this.quiet = true;
    }

    public void setM(int m) {
        this.mem = m;
    }

    public void setHistory(List<double[]> s, List<double[]> y) {
        this.presetInfo = new QNInfo(s, y);
    }

    private void computeDir(double[] dir2, double[] fg, double[] x, QNInfo qn, Function func) throws SurpriseConvergence {
        int i;
        System.arraycopy(fg, 0, dir2, 0, fg.length);
        int mmm = qn.size();
        double[] as = new double[mmm];
        for (i = mmm - 1; i >= 0; --i) {
            as[i] = qn.getRho(i) * ArrayMath.innerProduct(qn.getS(i), dir2);
            QNMinimizer.plusAndConstMult(dir2, qn.getY(i), -as[i], dir2);
        }
        qn.applyInitialHessian(dir2);
        for (i = 0; i < mmm; ++i) {
            double b = qn.getRho(i) * ArrayMath.innerProduct(qn.getY(i), dir2);
            QNMinimizer.plusAndConstMult(dir2, qn.getS(i), as[i] - b, dir2);
        }
        ArrayMath.multiplyInPlace(dir2, -1.0);
        if (this.useOWLQN) {
            QNMinimizer.constrainSearchDir(dir2, fg, x, func);
        }
    }

    private static double[] plusAndConstMult(double[] a, double[] b, double c, double[] d) {
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i] + c * b[i];
        }
        return d;
    }

    private double doEvaluation(double[] x) {
        if (this.evaluators == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double score = 0.0;
        for (Evaluator eval : this.evaluators) {
            if (!this.suppressTestPrompt) {
                this.say("  Evaluating: " + eval.toString());
            }
            score = eval.evaluate(x);
        }
        return score;
    }

    public float[] minimize(DiffFloatFunction function, float functionTolerance, float[] initial) {
        throw new UnsupportedOperationException("Float not yet supported for QN");
    }

    @Override
    public double[] minimize(DiffFunction function, double functionTolerance, double[] initial) {
        return this.minimize(function, functionTolerance, initial, -1);
    }

    @Override
    public double[] minimize(DiffFunction dfunction, double functionTolerance, double[] initial, int maxFunctionEvaluations) {
        return this.minimize(dfunction, functionTolerance, initial, maxFunctionEvaluations, null);
    }

    public double[] minimize(DiffFunction dfunction, double functionTolerance, double[] initial, int maxFunctionEvaluations, QNInfo qn) {
        this.say("QNMinimizer called on double function of " + dfunction.domainDimension() + " variables,");
        if (this.mem > 0) {
            this.sayln(" using M = " + this.mem + ".");
        } else {
            this.sayln(" using dynamic setting of M.");
        }
        if (qn == null && this.presetInfo == null) {
            qn = new QNInfo(this.mem);
            this.noHistory = true;
        } else if (this.presetInfo != null) {
            qn = this.presetInfo;
            this.noHistory = false;
        } else if (qn != null) {
            this.noHistory = false;
        }
        this.its = 0;
        this.fevals = 0;
        this.success = false;
        qn.scaleOpt = this.scaleOpt;
        double[] x = initial;
        double[] grad = new double[x.length];
        double[] newGrad = new double[x.length];
        double[] newX = new double[x.length];
        double[] dir2 = new double[x.length];
        double value = this.evaluateFunction(dfunction, x, grad);
        if (this.useOWLQN) {
            double norm = QNMinimizer.l1NormOWL(x, dfunction);
            value += norm * this.lambdaOWL;
            grad = this.pseudoGradientOWL(x, grad, dfunction);
        }
        PrintWriter outFile = null;
        PrintWriter infoFile = null;
        if (this.outputToFile) {
            try {
                String baseName = "QN_m" + this.mem + "_" + this.lsOpt.toString() + "_" + this.scaleOpt.toString();
                outFile = new PrintWriter(new FileOutputStream(baseName + ".output"), true);
                infoFile = new PrintWriter(new FileOutputStream(baseName + ".info"), true);
                infoFile.println(dfunction.domainDimension() + "; DomainDimension ");
                infoFile.println(this.mem + "; memory");
            }
            catch (IOException e) {
                throw new RuntimeIOException("Caught IOException outputting QN data to file", e);
            }
        }
        Record rec = new Record(this.quiet, this.monitor, functionTolerance, outFile);
        rec.start(value, grad, x);
        this.maxFevals = maxFunctionEvaluations > 0 ? maxFunctionEvaluations : Integer.MAX_VALUE;
        this.sayln("               An explanation of the output:");
        this.sayln("Iter           The number of iterations");
        this.sayln("evals          The number of function evaluations");
        this.sayln("SCALING        <D> Diagonal scaling was used; <I> Scaled Identity");
        this.sayln("LINESEARCH     [## M steplength]  Minpack linesearch");
        this.sayln("                   1-Function value was too high");
        this.sayln("                   2-Value ok, gradient positive, positive curvature");
        this.sayln("                   3-Value ok, gradient negative, positive curvature");
        this.sayln("                   4-Value ok, gradient negative, negative curvature");
        this.sayln("               [.. B]  Backtracking");
        this.sayln("VALUE          The current function value");
        this.sayln("TIME           Total elapsed time");
        this.sayln("|GNORM|        The current norm of the gradient");
        this.sayln("{RELNORM}      The ratio of the current to initial gradient norms");
        this.sayln("AVEIMPROVE     The average improvement / current value");
        this.sayln("EVALSCORE      The last available eval score");
        this.sayln();
        this.sayln("Iter ## evals ## <SCALING> [LINESEARCH] VALUE TIME |GNORM| {RELNORM} AVEIMPROVE EVALSCORE");
        do {
            try {
                this.sayln();
                boolean doEval = this.its >= 0 && this.its >= this.startEvaluateIters && this.evaluateIters > 0 && this.its % this.evaluateIters == 0;
                ++this.its;
                double[] newPoint = new double[3];
                this.say("Iter " + this.its + " evals " + this.fevals + " ");
                this.say("<");
                this.computeDir(dir2, grad, x, qn, dfunction);
                this.say("> ");
                boolean hasNaNDir = false;
                boolean hasNaNGrad = false;
                for (int i = 0; i < dir2.length; ++i) {
                    if (dir2[i] != dir2[i]) {
                        hasNaNDir = true;
                    }
                    if (grad[i] == grad[i]) continue;
                    hasNaNGrad = true;
                }
                if (hasNaNDir && !hasNaNGrad) {
                    this.say("(NaN dir likely due to Hessian approx - resetting) ");
                    qn.clear();
                    this.say("<");
                    this.computeDir(dir2, grad, x, qn, dfunction);
                    this.say("> ");
                }
                this.say("[");
                if (this.useOWLQN) {
                    newPoint = this.lineSearchBacktrackOWL(dfunction, dir2, x, newX, grad, value);
                    this.say("B");
                } else {
                    switch (this.lsOpt) {
                        case BACKTRACK: {
                            newPoint = this.lineSearchBacktrack(dfunction, dir2, x, newX, grad, value);
                            this.say("B");
                            break;
                        }
                        case MINPACK: {
                            newPoint = this.lineSearchMinPack(dfunction, dir2, x, newX, grad, value, functionTolerance);
                            this.say("M");
                            break;
                        }
                        default: {
                            this.sayln("Invalid line search option for QNMinimizer. ");
                            System.exit(1);
                        }
                    }
                }
                double newValue = newPoint[1];
                System.err.print(" " + nf.format(newPoint[0]));
                this.say("] ");
                System.arraycopy(dfunction.derivativeAt(newX), 0, newGrad, 0, newGrad.length);
                qn.update(newX, x, newGrad, grad, newPoint[0]);
                if (this.useOWLQN) {
                    newGrad = this.pseudoGradientOWL(newX, newGrad, dfunction);
                }
                double evalScore = Double.NEGATIVE_INFINITY;
                if (doEval) {
                    evalScore = this.doEvaluation(newX);
                }
                rec.add(newValue, newGrad, newX, this.fevals, evalScore);
                value = newValue;
                System.arraycopy(newX, 0, x, 0, x.length);
                System.arraycopy(newGrad, 0, grad, 0, newGrad.length);
                if (this.quiet) {
                    System.err.print(".");
                }
                if (this.fevals > this.maxFevals) {
                    throw new MaxEvaluationsExceeded(" Exceeded in minimize() loop ");
                }
            }
            catch (SurpriseConvergence s) {
                this.sayln();
                this.sayln("QNMinimizer aborted due to surprise convergence");
                break;
            }
            catch (MaxEvaluationsExceeded m) {
                this.sayln();
                this.sayln("QNMinimizer aborted due to maximum number of function evaluations");
                this.sayln(m.toString());
                this.sayln("** This is not an acceptable termination of QNMinimizer, consider");
                this.sayln("** increasing the max number of evaluations, or safeguarding your");
                this.sayln("** program by checking the QNMinimizer.wasSuccessful() method.");
                break;
            }
            catch (OutOfMemoryError oome) {
                this.sayln();
                if (!qn.s.isEmpty()) {
                    qn.s.remove(0);
                    qn.y.remove(0);
                    qn.rho.remove(0);
                    qn.mem = qn.s.size();
                    System.err.println("Caught OutOfMemoryError, changing m = " + qn.mem);
                    continue;
                }
                throw oome;
            }
        } while ((this.state = rec.toContinue()) == eState.CONTINUE);
        if (this.evaluateIters > 0) {
            double evalScore = this.useEvalImprovement ? this.doEvaluation(rec.getBest()) : this.doEvaluation(x);
            this.sayln("final evalScore is: " + evalScore);
        }
        System.err.println();
        switch (this.state) {
            case TERMINATE_GRADNORM: {
                System.err.println("QNMinimizer terminated due to numerically zero gradient: |g| < EPS  max(1,|x|) ");
                this.success = true;
                break;
            }
            case TERMINATE_RELATIVENORM: {
                System.err.println("QNMinimizer terminated due to sufficient decrease in gradient norms: |g|/|g0| < TOL ");
                this.success = true;
                break;
            }
            case TERMINATE_AVERAGEIMPROVE: {
                System.err.println("QNMinimizer terminated due to average improvement: | newest_val - previous_val | / |newestVal| < TOL ");
                this.success = true;
                break;
            }
            case TERMINATE_MAXITR: {
                System.err.println("QNMinimizer terminated due to reached max iteration " + this.maxItr);
                this.success = true;
                break;
            }
            case TERMINATE_EVALIMPROVE: {
                System.err.println("QNMinimizer terminated due to no improvement on eval ");
                this.success = true;
                x = rec.getBest();
                break;
            }
            default: {
                System.err.println("QNMinimizer terminated without converging");
                this.success = false;
            }
        }
        double completionTime = rec.howLong();
        this.sayln("Total time spent in optimization: " + nfsec.format(completionTime) + "s");
        if (this.outputToFile) {
            infoFile.println(completionTime + "; Total Time ");
            infoFile.println(this.fevals + "; Total evaluations");
            infoFile.close();
            outFile.close();
        }
        qn.free();
        return x;
    }

    private void sayln() {
        if (!this.quiet) {
            System.err.println();
        }
    }

    private void sayln(String s) {
        if (!this.quiet) {
            System.err.println(s);
        }
    }

    private void say(String s) {
        if (!this.quiet) {
            System.err.print(s);
        }
    }

    private double evaluateFunction(DiffFunction dfunc, double[] x, double[] grad) {
        System.arraycopy(dfunc.derivativeAt(x), 0, grad, 0, grad.length);
        ++this.fevals;
        return dfunc.valueAt(x);
    }

    public void useOWLQN(boolean use, double lambda) {
        this.useOWLQN = use;
        this.lambdaOWL = lambda;
    }

    private static Set<Integer> initializeParamRange(Function func, double[] x) {
        Set<Integer> paramRange;
        if (func instanceof HasRegularizerParamRange) {
            paramRange = ((HasRegularizerParamRange)((Object)func)).getRegularizerParamRange(x);
        } else {
            paramRange = Generics.newHashSet(x.length);
            for (int i = 0; i < x.length; ++i) {
                paramRange.add(i);
            }
        }
        return paramRange;
    }

    private static double[] projectOWL(double[] x, double[] orthant, Function func) {
        Set<Integer> paramRange = QNMinimizer.initializeParamRange(func, x);
        for (int i : paramRange) {
            if (!(x[i] * orthant[i] <= 0.0)) continue;
            x[i] = 0.0;
        }
        return x;
    }

    private static double l1NormOWL(double[] x, Function func) {
        Set<Integer> paramRange = QNMinimizer.initializeParamRange(func, x);
        double sum = 0.0;
        for (int i : paramRange) {
            sum += Math.abs(x[i]);
        }
        return sum;
    }

    private static void constrainSearchDir(double[] dir2, double[] fg, double[] x, Function func) {
        Set<Integer> paramRange = QNMinimizer.initializeParamRange(func, x);
        for (int i : paramRange) {
            if (!(dir2[i] * fg[i] >= 0.0)) continue;
            dir2[i] = 0.0;
        }
    }

    private double[] pseudoGradientOWL(double[] x, double[] grad, Function func) {
        Set<Integer> paramRange = QNMinimizer.initializeParamRange(func, x);
        double[] newGrad = new double[grad.length];
        for (int i = 0; i < x.length; ++i) {
            if (paramRange.contains(i)) {
                if (x[i] < 0.0) {
                    newGrad[i] = grad[i] - this.lambdaOWL;
                    continue;
                }
                if (x[i] > 0.0) {
                    newGrad[i] = grad[i] + this.lambdaOWL;
                    continue;
                }
                if (grad[i] < -this.lambdaOWL) {
                    newGrad[i] = grad[i] + this.lambdaOWL;
                    continue;
                }
                if (grad[i] > this.lambdaOWL) {
                    newGrad[i] = grad[i] - this.lambdaOWL;
                    continue;
                }
                newGrad[i] = 0.0;
                continue;
            }
            newGrad[i] = grad[i];
        }
        return newGrad;
    }

    private double[] lineSearchBacktrackOWL(Function func, double[] dir2, double[] x, double[] newX, double[] grad, double lastValue) throws MaxEvaluationsExceeded {
        double c1;
        double step;
        double[] orthant = new double[x.length];
        for (int i = 0; i < orthant.length; ++i) {
            orthant[i] = x[i] == 0.0 ? -grad[i] : x[i];
        }
        if (this.its <= 2) {
            step = 0.1;
            c1 = 0.1;
        } else {
            step = 1.0;
            c1 = 0.1;
        }
        double c = 0.01;
        double[] newPoint = new double[3];
        while (true) {
            QNMinimizer.plusAndConstMult(x, dir2, step, newX);
            QNMinimizer.projectOWL(newX, orthant, func);
            double value = func.valueAt(newX);
            double norm = QNMinimizer.l1NormOWL(newX, func);
            newPoint[1] = value += norm * this.lambdaOWL;
            double dgtest = 0.0;
            for (int i = 0; i < x.length; ++i) {
                dgtest += (newX[i] - x[i]) * grad[i];
            }
            if (newPoint[1] <= lastValue + c * dgtest) break;
            if (newPoint[1] < lastValue) {
                this.say("!");
            } else {
                this.say(".");
            }
            step = c1 * step;
        }
        newPoint[0] = step;
        ++this.fevals;
        if (this.fevals > this.maxFevals) {
            throw new MaxEvaluationsExceeded(" Exceeded during linesearch() Function ");
        }
        return newPoint;
    }

    private double[] lineSearchBacktrack(Function func, double[] dir2, double[] x, double[] newX, double[] grad, double lastValue) throws MaxEvaluationsExceeded {
        double c1;
        double step;
        double normGradInDir = ArrayMath.innerProduct(dir2, grad);
        this.say("(" + nf.format(normGradInDir) + ")");
        if (normGradInDir > 0.0) {
            this.say("{WARNING--- direction of positive gradient chosen!}");
        }
        if (this.its <= 2) {
            step = 0.1;
            c1 = 0.1;
        } else {
            step = 1.0;
            c1 = 0.1;
        }
        double c = 0.01;
        c *= normGradInDir;
        double[] newPoint = new double[3];
        while (true) {
            double d;
            newPoint[1] = func.valueAt(QNMinimizer.plusAndConstMult(x, dir2, step, newX));
            if (!(d > lastValue + c * step)) break;
            ++this.fevals;
            if (newPoint[1] < lastValue) {
                this.say("!");
            } else {
                this.say(".");
            }
            step = c1 * step;
        }
        newPoint[0] = step;
        ++this.fevals;
        if (this.fevals > this.maxFevals) {
            throw new MaxEvaluationsExceeded(" Exceeded during linesearch() Function ");
        }
        return newPoint;
    }

    private double[] lineSearchMinPack(DiffFunction dfunc, double[] dir2, double[] x, double[] newX, double[] grad, double f0, double tol) throws MaxEvaluationsExceeded {
        double xtrapf = 4.0;
        int info = 0;
        int infoc = 1;
        this.bracketed = false;
        boolean stage1 = true;
        double width = 1.0E12;
        double width1 = 2.0 * width;
        double g0 = ArrayMath.innerProduct(grad, dir2);
        if (g0 >= 0.0) {
            for (int i = 0; i < x.length; ++i) {
                dir2[i] = -grad[i];
            }
            g0 = ArrayMath.innerProduct(grad, dir2);
        }
        double gTest = 1.0E-4 * g0;
        double[] newPt = new double[3];
        double[] bestPt = new double[3];
        double[] endPt = new double[3];
        newPt[0] = 1.0;
        if (this.its == 1 && this.noHistory) {
            newPt[0] = 0.1;
        }
        bestPt[0] = 0.0;
        bestPt[1] = f0;
        bestPt[2] = g0;
        endPt[0] = 0.0;
        endPt[1] = f0;
        endPt[2] = g0;
        while (true) {
            double stpMax;
            double stpMin;
            if (this.bracketed) {
                stpMin = Math.min(bestPt[0], endPt[0]);
                stpMax = Math.max(bestPt[0], endPt[0]);
            } else {
                stpMin = bestPt[0];
                stpMax = newPt[0] + xtrapf * (newPt[0] - bestPt[0]);
            }
            newPt[0] = Math.max(newPt[0], 1.0E-12);
            newPt[0] = Math.min(newPt[0], 1.0E12);
            if (this.bracketed && (newPt[0] <= stpMin || newPt[0] >= stpMax) || this.fevals >= this.maxFevals || infoc == 0 || this.bracketed && stpMax - stpMin <= tol * stpMax) {
                QNMinimizer.plusAndConstMult(x, dir2, bestPt[0], newX);
                newPt[1] = bestPt[1];
                newPt[0] = bestPt[0];
            }
            newPt[1] = dfunc.valueAt(QNMinimizer.plusAndConstMult(x, dir2, newPt[0], newX));
            newPt[2] = ArrayMath.innerProduct(dfunc.derivativeAt(newX), dir2);
            double fTest = f0 + newPt[0] * gTest;
            ++this.fevals;
            if (this.bracketed && (newPt[0] <= stpMin || newPt[0] >= stpMax) || infoc == 0) {
                info = 6;
                this.say(" line search failure: bracketed but no feasible found ");
            }
            if (newPt[0] == 1.0E12 && newPt[1] <= fTest && newPt[2] <= gTest) {
                info = 5;
                this.say(" line search failure: sufficient decrease, but gradient is more negative ");
            }
            if (newPt[0] == 1.0E-12 && (newPt[1] > fTest || newPt[2] >= gTest)) {
                info = 4;
                this.say(" line search failure: minimum step length reached ");
            }
            if (this.fevals >= this.maxFevals) {
                info = 3;
                throw new MaxEvaluationsExceeded(" Exceeded during lineSearchMinPack() Function ");
            }
            if (this.bracketed && stpMax - stpMin <= tol * stpMax) {
                info = 2;
                this.say(" line search failure: interval is too small ");
            }
            if (newPt[1] <= fTest && Math.abs(newPt[2]) <= -this.gtol * g0) {
                info = 1;
            }
            if (info != 0) {
                return newPt;
            }
            if (stage1 && newPt[1] <= fTest && newPt[2] >= Math.min(1.0E-4, this.gtol) * g0) {
                stage1 = false;
            }
            if (stage1 && newPt[1] <= bestPt[1] && newPt[1] > fTest) {
                newPt[1] = newPt[1] - newPt[0] * gTest;
                bestPt[1] = bestPt[1] - bestPt[0] * gTest;
                endPt[1] = endPt[1] - endPt[0] * gTest;
                newPt[2] = newPt[2] - gTest;
                bestPt[2] = bestPt[2] - gTest;
                endPt[2] = endPt[2] - gTest;
                infoc = this.getStep(newPt, bestPt, endPt, stpMin, stpMax);
                bestPt[1] = bestPt[1] + bestPt[0] * gTest;
                endPt[1] = endPt[1] + endPt[0] * gTest;
                bestPt[2] = bestPt[2] + gTest;
                endPt[2] = endPt[2] + gTest;
            } else {
                infoc = this.getStep(newPt, bestPt, endPt, stpMin, stpMax);
            }
            if (!this.bracketed) continue;
            if (Math.abs(endPt[0] - bestPt[0]) >= 0.66 * width1) {
                newPt[0] = bestPt[0] + 0.5 * (endPt[0] - bestPt[0]);
            }
            width1 = width;
            width = Math.abs(endPt[0] - bestPt[0]);
        }
    }

    private int getStep(double[] newPt, double[] bestPt, double[] endPt, double stpMin, double stpMax) throws MaxEvaluationsExceeded {
        double stpf;
        boolean bound;
        int info;
        double signG = newPt[2] * bestPt[2] / Math.abs(bestPt[2]);
        if (newPt[1] > bestPt[1]) {
            info = 1;
            bound = true;
            double theta = 3.0 * (bestPt[1] - newPt[1]) / (newPt[0] - bestPt[0]) + bestPt[2] + newPt[2];
            double s = Math.max(Math.max(theta, newPt[2]), bestPt[2]);
            double gamma = s * Math.sqrt(theta / s * (theta / s) - bestPt[2] / s * (newPt[2] / s));
            if (newPt[0] < bestPt[0]) {
                gamma = -gamma;
            }
            double p = gamma - bestPt[2] + theta;
            double q = gamma - bestPt[2] + gamma + newPt[2];
            double r = p / q;
            double stpc = bestPt[0] + r * (newPt[0] - bestPt[0]);
            double stpq = bestPt[0] + bestPt[2] / ((bestPt[1] - newPt[1]) / (newPt[0] - bestPt[0]) + bestPt[2]) / 2.0 * (newPt[0] - bestPt[0]);
            stpf = Math.abs(stpc - bestPt[0]) < Math.abs(stpq - bestPt[0]) ? stpc : stpq;
            this.bracketed = true;
            if (newPt[0] < 0.1) {
                stpf = 0.01 * stpf;
            }
        } else if (signG < 0.0) {
            info = 2;
            bound = false;
            double theta = 3.0 * (bestPt[1] - newPt[1]) / (newPt[0] - bestPt[0]) + bestPt[2] + newPt[2];
            double s = Math.max(Math.max(theta, bestPt[2]), newPt[2]);
            double gamma = s * Math.sqrt(theta / s * (theta / s) - bestPt[2] / s * (newPt[2] / s));
            if (newPt[0] > bestPt[0]) {
                gamma = -gamma;
            }
            double p = gamma - newPt[2] + theta;
            double q = gamma - newPt[2] + gamma + bestPt[2];
            double r = p / q;
            double stpc = newPt[0] + r * (bestPt[0] - newPt[0]);
            double stpq = newPt[0] + newPt[2] / (newPt[2] - bestPt[2]) * (bestPt[0] - newPt[0]);
            stpf = Math.abs(stpc - newPt[0]) > Math.abs(stpq - newPt[0]) ? stpc : stpq;
            this.bracketed = true;
        } else if (Math.abs(newPt[2]) < Math.abs(bestPt[2])) {
            double q;
            double p;
            double r;
            info = 3;
            bound = true;
            double theta = 3.0 * (bestPt[1] - newPt[1]) / (newPt[0] - bestPt[0]) + bestPt[2] + newPt[2];
            double s = Math.max(Math.max(theta, bestPt[2]), newPt[2]);
            double gamma = s * Math.sqrt(Math.max(0.0, theta / s * (theta / s) - bestPt[2] / s * (newPt[2] / s)));
            if (newPt[0] < bestPt[0]) {
                gamma = -gamma;
            }
            double stpc = (r = (p = gamma - bestPt[2] + theta) / (q = gamma - bestPt[2] + gamma + newPt[2])) < 0.0 && gamma != 0.0 ? newPt[0] + r * (bestPt[0] - newPt[0]) : (newPt[0] > bestPt[0] ? stpMax : stpMin);
            double stpq = newPt[0] + newPt[2] / (newPt[2] - bestPt[2]) * (bestPt[0] - newPt[0]);
            stpf = this.bracketed ? (Math.abs(newPt[0] - stpc) < Math.abs(newPt[0] - stpq) ? stpc : stpq) : (Math.abs(newPt[0] - stpc) > Math.abs(newPt[0] - stpq) ? stpc : stpq);
        } else {
            info = 4;
            bound = false;
            if (this.bracketed) {
                double stpc;
                double theta = 3.0 * (bestPt[1] - newPt[1]) / (newPt[0] - bestPt[0]) + bestPt[2] + newPt[2];
                double s = Math.max(Math.max(theta, bestPt[2]), newPt[2]);
                double gamma = s * Math.sqrt(theta / s * (theta / s) - bestPt[2] / s * (newPt[2] / s));
                if (newPt[0] > bestPt[0]) {
                    gamma = -gamma;
                }
                double p = gamma - newPt[2] + theta;
                double q = gamma - newPt[2] + gamma + bestPt[2];
                double r = p / q;
                stpf = stpc = newPt[0] + r * (bestPt[0] - newPt[0]);
            } else {
                stpf = newPt[0] > bestPt[0] ? stpMax : stpMin;
            }
        }
        if (newPt[1] > bestPt[1]) {
            QNMinimizer.copy(newPt, endPt);
        } else {
            if (signG < 0.0) {
                QNMinimizer.copy(bestPt, endPt);
            }
            QNMinimizer.copy(newPt, bestPt);
        }
        this.say(String.valueOf(info));
        stpf = Math.min(stpMax, stpf);
        newPt[0] = stpf = Math.max(stpMin, stpf);
        if (this.bracketed && bound) {
            newPt[0] = endPt[0] > bestPt[0] ? Math.min(bestPt[0] + 0.66 * (endPt[0] - bestPt[0]), newPt[0]) : Math.max(bestPt[0] + 0.66 * (endPt[0] - bestPt[0]), newPt[0]);
        }
        return info;
    }

    private static void copy(double[] src, double[] dest) {
        System.arraycopy(src, 0, dest, 0, src.length);
    }

    public class QNInfo {
        private List<double[]> s = null;
        private List<double[]> y = null;
        private List<Double> rho = null;
        private double gamma = 1.0;
        public double[] d = null;
        private int mem;
        private int maxMem = 20;
        public eScaling scaleOpt = eScaling.SCALAR;

        public QNInfo(int size) {
            this.s = new ArrayList<double[]>();
            this.y = new ArrayList<double[]>();
            this.rho = new ArrayList<Double>();
            this.mem = size;
        }

        public QNInfo() {
            this.s = new ArrayList<double[]>();
            this.y = new ArrayList<double[]>();
            this.rho = new ArrayList<Double>();
            this.mem = this.maxMem;
        }

        public QNInfo(List<double[]> sList, List<double[]> yList) {
            this.s = new ArrayList<double[]>();
            this.y = new ArrayList<double[]>();
            this.rho = new ArrayList<Double>();
            this.setHistory(sList, yList);
        }

        public int size() {
            return this.s.size();
        }

        public double getRho(int ind) {
            return this.rho.get(ind);
        }

        public double[] getS(int ind) {
            return this.s.get(ind);
        }

        public double[] getY(int ind) {
            return this.y.get(ind);
        }

        public void useDiagonalScaling() {
            this.scaleOpt = eScaling.DIAGONAL;
        }

        public void useScalarScaling() {
            this.scaleOpt = eScaling.SCALAR;
        }

        public void free() {
            this.s = null;
            this.y = null;
            this.rho = null;
            this.d = null;
        }

        public void clear() {
            this.s.clear();
            this.y.clear();
            this.rho.clear();
            this.d = null;
        }

        public void setHistory(List<double[]> sList, List<double[]> yList) {
            int size = sList.size();
            for (int i = 0; i < size; ++i) {
                this.update(sList.get(i), yList.get(i), ArrayMath.innerProduct(yList.get(i), yList.get(i)), ArrayMath.innerProduct(sList.get(i), yList.get(i)), 0.0, 1.0);
            }
        }

        public double[] applyInitialHessian(double[] x) {
            switch (this.scaleOpt) {
                case SCALAR: {
                    QNMinimizer.this.say("I");
                    ArrayMath.multiplyInPlace(x, this.gamma);
                    break;
                }
                case DIAGONAL: {
                    QNMinimizer.this.say("D");
                    if (this.d == null) break;
                    if (x.length != this.d.length) {
                        throw new IllegalArgumentException("Vector of incorrect size passed to applyInitialHessian in QNInfo class");
                    }
                    for (int i = 0; i < x.length; ++i) {
                        x[i] = x[i] / this.d[i];
                    }
                    break;
                }
            }
            return x;
        }

        public int update(double[] newX, double[] x, double[] newGrad, double[] grad, double step) throws SurpriseConvergence {
            double[] newY;
            double[] newS;
            if (this.mem > 0 && this.s.size() == this.mem || this.s.size() == this.maxMem) {
                newS = this.s.remove(0);
                newY = this.y.remove(0);
                this.rho.remove(0);
            } else {
                newS = new double[x.length];
                newY = new double[x.length];
            }
            double sy = 0.0;
            double yy = 0.0;
            double sg = 0.0;
            for (int i = 0; i < x.length; ++i) {
                newS[i] = newX[i] - x[i];
                newY[i] = newGrad[i] - grad[i];
                sy += newS[i] * newY[i];
                yy += newY[i] * newY[i];
                sg += newS[i] * newGrad[i];
            }
            return this.update(newS, newY, yy, sy, sg, step);
        }

        public int update(double[] newS, double[] newY, double yy, double sy, double sg, double step) {
            if (this.scaleOpt == eScaling.DIAGONAL && this.d == null) {
                this.d = new double[newS.length];
                for (int i = 0; i < this.d.length; ++i) {
                    this.d[i] = 1.0;
                }
            }
            try {
                if (sy < 0.0) {
                    throw new NegativeCurvature();
                }
                if (yy == 0.0) {
                    throw new ZeroGradient();
                }
                switch (this.scaleOpt) {
                    case SCALAR: {
                        this.gamma = sy / yy;
                        break;
                    }
                    case DIAGONAL: {
                        int i;
                        this.gamma = sy / (step * (sy - sg));
                        double sDs = 0.0;
                        for (i = 0; i < this.d.length; ++i) {
                            this.d[i] = this.gamma * this.d[i];
                            sDs += newS[i] * this.d[i] * newS[i];
                        }
                        for (i = 0; i < this.d.length; ++i) {
                            this.d[i] = (1.0 - this.d[i] * newS[i] * newS[i] / sDs) * this.d[i] + newY[i] * newY[i] / sy;
                        }
                        double minD = ArrayMath.min(this.d);
                        double maxD = ArrayMath.max(this.d);
                        if (!(minD <= 0.0) && !Double.isInfinite(maxD) && !(maxD / minD > 1.0E12)) break;
                        System.err.println("QNInfo:update() : PROBLEM WITH DIAGONAL UPDATE");
                        double fill = yy / sy;
                        for (int i2 = 0; i2 < this.d.length; ++i2) {
                            this.d[i2] = fill;
                        }
                        break;
                    }
                }
                if (this.mem > 0 && this.s.size() == this.mem || this.s.size() == this.maxMem) {
                    this.s.remove(0);
                    this.y.remove(0);
                    this.rho.remove(0);
                }
                this.s.add(newS);
                this.y.add(newY);
                this.rho.add(1.0 / sy);
            }
            catch (NegativeCurvature nc) {
                QNMinimizer.this.say(" Negative curvature detected, update skipped ");
            }
            catch (ZeroGradient zg) {
                QNMinimizer.this.say(" Either convergence, or floating point errors combined with extremely linear region ");
            }
            return this.s.size();
        }

        private class ZeroGradient
        extends Throwable {
            private static final long serialVersionUID = -4001834044987928521L;
        }

        private class NegativeCurvature
        extends Throwable {
            private static final long serialVersionUID = 4676562552506850519L;
        }
    }

    public class Record {
        private final List<Double> evals = new ArrayList<Double>();
        private final List<Double> values = new ArrayList<Double>();
        List<Double> gNorms = new ArrayList<Double>();
        private final List<Integer> funcEvals = new ArrayList<Integer>();
        private final List<Double> time = new ArrayList<Double>();
        private double gNormInit = Double.MIN_VALUE;
        private double relativeTOL = 1.0E-8;
        private double TOL = 1.0E-6;
        private double EPS = 1.0E-6;
        private long startTime;
        private double gNormLast;
        private double[] xLast;
        private int maxSize = 100;
        private Function mon = null;
        private boolean quiet = false;
        private boolean memoryConscious = true;
        private PrintWriter outputFile = null;
        private int noImproveItrCount = 0;
        private double[] xBest;

        public Record(boolean beQuiet, Function monitor, double tolerance) {
            this.quiet = beQuiet;
            this.mon = monitor;
            this.TOL = tolerance;
        }

        public Record(boolean beQuiet, Function monitor, double tolerance, PrintWriter output) {
            this.quiet = beQuiet;
            this.mon = monitor;
            this.TOL = tolerance;
            this.outputFile = output;
        }

        public Record(boolean beQuiet, Function monitor, double tolerance, double eps) {
            this.quiet = beQuiet;
            this.mon = monitor;
            this.TOL = tolerance;
            this.EPS = eps;
        }

        public void setEPS(double eps) {
            this.EPS = eps;
        }

        public void setTOL(double tolerance) {
            this.TOL = tolerance;
        }

        public void start(double val, double[] grad) {
            this.start(val, grad, null);
        }

        public void shutUp() {
            this.quiet = true;
        }

        public void start(double val, double[] grad, double[] x) {
            this.startTime = System.currentTimeMillis();
            this.gNormInit = ArrayMath.norm(grad);
            this.xLast = x;
            this.writeToFile(1.0, val, this.gNormInit, 0.0);
            if (x != null) {
                this.monitorX(x);
            }
        }

        private void writeToFile(double fevals, double val, double gNorm, double time) {
            if (this.outputFile != null) {
                this.outputFile.println(fevals + "," + val + "," + gNorm + "," + time);
            }
        }

        public void add(double val, double[] grad, double[] x, int fevals, double evalScore) {
            if (!this.memoryConscious) {
                if (this.gNorms.size() > this.maxSize) {
                    this.gNorms.remove(0);
                }
                if (this.time.size() > this.maxSize) {
                    this.time.remove(0);
                }
                if (this.funcEvals.size() > this.maxSize) {
                    this.funcEvals.remove(0);
                }
                this.gNorms.add(this.gNormLast);
                this.time.add(this.howLong());
                this.funcEvals.add(fevals);
            } else {
                this.maxSize = 10;
            }
            this.gNormLast = ArrayMath.norm(grad);
            if (this.values.size() > this.maxSize) {
                this.values.remove(0);
            }
            this.values.add(val);
            if (evalScore != Double.NEGATIVE_INFINITY) {
                this.evals.add(evalScore);
            }
            this.writeToFile(fevals, val, this.gNormLast, this.howLong());
            QNMinimizer.this.say(nf.format(val) + " " + nfsec.format(this.howLong()) + "s");
            this.xLast = x;
            this.monitorX(x);
        }

        public void monitorX(double[] x) {
            if (this.mon != null) {
                this.mon.valueAt(x);
            }
        }

        public eState toContinue() {
            double relNorm = this.gNormLast / this.gNormInit;
            int size = this.values.size();
            double newestVal = this.values.get(size - 1);
            double previousVal = size >= 10 ? this.values.get(size - 10) : this.values.get(0);
            double averageImprovement = (previousVal - newestVal) / (double)(size >= 10 ? 10 : size);
            int evalsSize = this.evals.size();
            if (QNMinimizer.this.useMaxItr && QNMinimizer.this.its >= QNMinimizer.this.maxItr) {
                return eState.TERMINATE_MAXITR;
            }
            if (QNMinimizer.this.useEvalImprovement) {
                int bestInd = -1;
                double bestScore = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < evalsSize; ++i) {
                    if (!(this.evals.get(i) >= bestScore)) continue;
                    bestScore = this.evals.get(i);
                    bestInd = i;
                }
                if (bestInd == evalsSize - 1) {
                    if (this.xBest == null) {
                        this.xBest = Arrays.copyOf(this.xLast, this.xLast.length);
                    } else {
                        System.arraycopy(this.xLast, 0, this.xBest, 0, this.xLast.length);
                    }
                }
                if (evalsSize - bestInd >= QNMinimizer.this.terminateOnEvalImprovementNumOfEpoch) {
                    return eState.TERMINATE_EVALIMPROVE;
                }
            }
            if (QNMinimizer.this.useAveImprovement && size > 5 && Math.abs(averageImprovement / newestVal) < this.TOL) {
                return eState.TERMINATE_AVERAGEIMPROVE;
            }
            if (QNMinimizer.this.useRelativeNorm && relNorm <= this.relativeTOL) {
                return eState.TERMINATE_RELATIVENORM;
            }
            if (QNMinimizer.this.useNumericalZero && this.gNormLast < this.EPS * Math.max(1.0, ArrayMath.norm_1(this.xLast)) && this.gNormLast < this.EPS * Math.max(1.0, ArrayMath.norm(this.xLast))) {
                System.err.println("Gradient is numerically zero, stopped on machine epsilon.");
                return eState.TERMINATE_GRADNORM;
            }
            QNMinimizer.this.say(" |" + nf.format(this.gNormLast) + "| {" + nf.format(relNorm) + "} " + nf.format(Math.abs(averageImprovement / newestVal)) + " " + (evalsSize > 0 ? this.evals.get(evalsSize - 1).toString() : "-") + " ");
            return eState.CONTINUE;
        }

        public double howLong() {
            return (double)(System.currentTimeMillis() - this.startTime) / 1000.0;
        }

        public double[] getBest() {
            return this.xBest;
        }
    }

    private static class MaxEvaluationsExceeded
    extends Throwable {
        private static final long serialVersionUID = 8044806163343218660L;

        public MaxEvaluationsExceeded(String s) {
            super(s);
        }
    }

    public static class SurpriseConvergence
    extends Throwable {
        private static final long serialVersionUID = 4290178321643529559L;

        public SurpriseConvergence(String s) {
            super(s);
        }
    }

    public static enum eScaling {
        DIAGONAL,
        SCALAR;

    }

    public static enum eLineSearch {
        BACKTRACK,
        MINPACK;

    }

    public static enum eState {
        TERMINATE_MAXEVALS,
        TERMINATE_RELATIVENORM,
        TERMINATE_GRADNORM,
        TERMINATE_AVERAGEIMPROVE,
        CONTINUE,
        TERMINATE_EVALIMPROVE,
        TERMINATE_MAXITR;

    }
}

