/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BasicSequenceMatchResult<T>
implements SequenceMatchResult<T> {
    SequencePattern<T> pattern;
    List<? extends T> elements;
    MatchedGroup[] matchedGroups;
    Object[] matchedResults;
    Function<List<? extends T>, String> nodesToStringConverter;
    SequencePattern.VarGroupBindings varGroupBindings;
    double score = 0.0;
    int order;

    @Override
    public List<? extends T> elements() {
        return this.elements;
    }

    @Override
    public SequencePattern<T> pattern() {
        return this.pattern;
    }

    @Override
    public BasicSequenceMatchResult<T> toBasicSequenceMatchResult() {
        return this.copy();
    }

    public BasicSequenceMatchResult<T> copy() {
        BasicSequenceMatchResult<T> res = new BasicSequenceMatchResult<T>();
        res.pattern = this.pattern;
        res.elements = this.elements;
        res.matchedGroups = new MatchedGroup[this.matchedGroups.length];
        res.nodesToStringConverter = this.nodesToStringConverter;
        res.score = this.score;
        res.order = this.order;
        res.varGroupBindings = this.varGroupBindings;
        for (int i = 0; i < this.matchedGroups.length; ++i) {
            if (this.matchedGroups[i] == null) continue;
            res.matchedGroups[i] = new MatchedGroup(this.matchedGroups[i]);
        }
        if (this.matchedResults != null) {
            res.matchedResults = new Object[res.matchedResults.length];
            System.arraycopy(res.matchedResults, 0, this.matchedResults, 0, this.matchedResults.length);
        }
        return res;
    }

    @Override
    public Interval<Integer> getInterval() {
        return TO_INTERVAL.apply(this);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public int start() {
        return this.start(0);
    }

    @Override
    public int start(int group) {
        if (group == Integer.MIN_VALUE) {
            return 0;
        }
        if (group == -2147483647) {
            return this.matchedGroups[0].matchEnd;
        }
        if (this.matchedGroups[group] != null) {
            return this.matchedGroups[group].matchBegin;
        }
        return -1;
    }

    @Override
    public int start(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.start(g);
        }
        return -1;
    }

    @Override
    public int end() {
        return this.end(0);
    }

    @Override
    public int end(int group) {
        if (group == Integer.MIN_VALUE) {
            return this.matchedGroups[0].matchBegin;
        }
        if (group == -2147483647) {
            return this.elements.size();
        }
        if (this.matchedGroups[group] != null) {
            return this.matchedGroups[group].matchEnd;
        }
        return -1;
    }

    @Override
    public int end(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.end(g);
        }
        return -1;
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int group) {
        List<T> groupTokens = this.groupNodes(group);
        if (this.nodesToStringConverter == null) {
            return groupTokens != null ? StringUtils.join(groupTokens, " ") : null;
        }
        return this.nodesToStringConverter.apply(groupTokens);
    }

    @Override
    public String group(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.group(g);
        }
        return null;
    }

    @Override
    public List<T> groupNodes() {
        return this.groupNodes(0);
    }

    @Override
    public List<T> groupNodes(int group) {
        if (group == Integer.MIN_VALUE || group == -2147483647) {
            return new ArrayList<T>(this.elements.subList(this.start(group), this.end(group)));
        }
        if (this.matchedGroups[group] != null) {
            return new ArrayList<T>(this.elements.subList(this.matchedGroups[group].matchBegin, this.matchedGroups[group].matchEnd));
        }
        return null;
    }

    @Override
    public List<? extends T> groupNodes(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.groupNodes(g);
        }
        return null;
    }

    @Override
    public Object groupValue() {
        return this.groupValue(0);
    }

    @Override
    public Object groupValue(int group) {
        if (group == Integer.MIN_VALUE || group == -2147483647) {
            return new ArrayList<T>(this.elements.subList(this.start(group), this.end(group)));
        }
        if (this.matchedGroups[group] != null) {
            return this.matchedGroups[group].value;
        }
        return null;
    }

    @Override
    public Object groupValue(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.groupValue(g);
        }
        return null;
    }

    @Override
    public SequenceMatchResult.MatchedGroupInfo<T> groupInfo() {
        return this.groupInfo(0);
    }

    @Override
    public SequenceMatchResult.MatchedGroupInfo<T> groupInfo(int group) {
        List<T> nodes = this.groupNodes(group);
        if (nodes != null) {
            Object value = this.groupValue(group);
            String text = this.group(group);
            List<Object> matchedResults = this.groupMatchResults(group);
            return new SequenceMatchResult.MatchedGroupInfo<T>(text, nodes, matchedResults, value);
        }
        return null;
    }

    @Override
    public SequenceMatchResult.MatchedGroupInfo<T> groupInfo(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.groupInfo(g);
        }
        return null;
    }

    @Override
    public int groupCount() {
        return this.matchedGroups.length - 1;
    }

    @Override
    public List<Object> groupMatchResults() {
        return this.groupMatchResults(0);
    }

    @Override
    public List<Object> groupMatchResults(int group) {
        if (this.matchedResults == null) {
            return null;
        }
        if (group == Integer.MIN_VALUE || group == -2147483647) {
            return Arrays.asList(Arrays.copyOfRange(this.matchedResults, this.start(group), this.end(group)));
        }
        if (this.matchedGroups[group] != null) {
            return Arrays.asList(Arrays.copyOfRange(this.matchedResults, this.matchedGroups[group].matchBegin, this.matchedGroups[group].matchEnd));
        }
        return null;
    }

    @Override
    public List<Object> groupMatchResults(String var) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.groupMatchResults(g);
        }
        return null;
    }

    @Override
    public Object nodeMatchResult(int index) {
        if (this.matchedResults != null) {
            return this.matchedResults[index];
        }
        return null;
    }

    @Override
    public Object groupMatchResult(int group, int index) {
        if (this.matchedResults != null) {
            int s = this.start(group);
            int e = this.end(group);
            if (s >= 0 && e > s) {
                int d = e - s;
                if (index >= 0 && index < d) {
                    return this.matchedResults[s + index];
                }
            }
        }
        return null;
    }

    @Override
    public Object groupMatchResult(String var, int index) {
        int g = this.getFirstVarGroup(var);
        if (g >= 0) {
            return this.groupMatchResult(g, index);
        }
        return null;
    }

    private int getFirstVarGroup(String v) {
        v = v.trim();
        for (int i = 0; i < this.varGroupBindings.varnames.length; ++i) {
            String s = this.varGroupBindings.varnames[i];
            if (!v.equals(s) || this.matchedGroups[i] == null) continue;
            return i;
        }
        return -1;
    }

    protected static class MatchedGroup {
        int matchBegin = -1;
        int matchEnd = -1;
        Object value = null;

        protected MatchedGroup(MatchedGroup mg) {
            this.matchBegin = mg.matchBegin;
            this.matchEnd = mg.matchEnd;
            this.value = mg.value;
        }

        protected MatchedGroup(int matchBegin, int matchEnd, Object value) {
            this.matchBegin = matchBegin;
            this.matchEnd = matchEnd;
            this.value = value;
        }

        public String toString() {
            return "(" + this.matchBegin + "," + this.matchEnd + ")";
        }
    }
}

