/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.NoSuchElementException;
import java.util.zip.GZIPOutputStream;

public final class FileSystem {
    private FileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (Exception e) {
            System.err.printf("FileSystem: Error copying %s to %s\n", sourceFile.getPath(), destFile.getPath());
            e.printStackTrace();
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void gzipFile(File uncompressedFileName, File compressedFileName) throws IOException {
        int len;
        GZIPOutputStream out2 = new GZIPOutputStream(new FileOutputStream(compressedFileName));
        FileInputStream in = new FileInputStream(uncompressedFileName);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out2.write(buf, 0, len);
        }
        in.close();
        out2.finish();
        out2.close();
    }

    public static boolean deleteDir(File dir2) {
        if (dir2.isDirectory()) {
            String[] children = dir2.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileSystem.deleteDir(new File(dir2, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir2.delete();
    }

    public static boolean existsAndNonEmpty(File file) {
        String firstLine;
        if (!file.exists()) {
            return false;
        }
        Iterable<String> lines = IOUtils.readLines(file);
        try {
            firstLine = lines.iterator().next();
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
        return firstLine.length() > 0;
    }

    public static void mkdirOrFail(String dir2) {
        FileSystem.mkdirOrFail(new File(dir2));
    }

    public static void mkdirOrFail(File dir2) {
        if (!dir2.mkdirs()) {
            String error = "Could not create " + dir2;
            System.err.println(error);
            throw new RuntimeException(error);
        }
    }

    public static void checkExistsOrFail(File file) {
        if (!file.exists()) {
            String error = "Output path " + file + " does not exist";
            System.err.println(error);
            throw new RuntimeException(error);
        }
    }

    public static void checkNotExistsOrFail(File file) {
        if (file.exists()) {
            String error = "Output path " + file + " already exists";
            System.err.println(error);
            throw new RuntimeException(error);
        }
    }

    public static void main(String[] args) {
        String testDirName = "FileSystemTest";
        String testFileName = "Pair.java";
        File testDir = new File(testDirName);
        testDir.mkdir();
        try {
            FileSystem.copyFile(new File(testFileName), new File(testDirName + "/" + testFileName));
        }
        catch (IOException e) {
            System.err.println("Copy failed");
            System.exit(-1);
        }
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(String.format("tar -cf %s.tar %s", testDirName, testDirName));
            int ret_val = p.waitFor();
            if (ret_val != 0) {
                System.err.printf("tar command returned %d\n", ret_val);
                System.exit(-1);
            }
        }
        catch (IOException e) {
            System.err.println("Tar command failed");
            System.exit(-1);
        }
        catch (InterruptedException e) {
            System.err.println("Tar command interrupted");
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            FileSystem.gzipFile(new File(String.format(testDirName + ".tar", new Object[0])), new File(testDirName + ".tar.gz"));
        }
        catch (IOException e) {
            System.err.println("gzip command failed");
            System.exit(-1);
        }
        boolean deleteSuccess = FileSystem.deleteDir(new File(testDirName));
        if (!deleteSuccess) {
            System.err.println("Could not delete directory");
            System.exit(-1);
        }
        System.out.println("Success!");
    }
}

