/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.writer;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.WordStemmer;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WriteXMLFile {
    public void writeSentence(String sentence, int id, Document doc, Element root) {
        String[] tokens = sentence.split(" ");
        String[] posTags = new String[tokens.length];
        Element sent = doc.createElement("s");
        Attr attr = doc.createAttribute("id");
        attr.setValue("" + id);
        sent.setAttributeNode(attr);
        for (int i = 0; i < tokens.length; ++i) {
            Element word = doc.createElement("w");
            Attr attrW = doc.createAttribute("id");
            attrW.setValue("" + id);
            word.setAttributeNode(attrW);
            attrW = doc.createAttribute("t");
            attrW.setValue("" + tokens[i]);
            word.setAttributeNode(attrW);
            Element moot = doc.createElement("moot");
            Attr attrM = doc.createAttribute("word");
            attrM.setValue("" + tokens[i]);
            moot.setAttributeNode(attrM);
            attrM = doc.createAttribute("tag");
            attrM.setValue("" + posTags[i]);
            moot.setAttributeNode(attrM);
            attrM = doc.createAttribute("lemma");
            attrM.setValue("" + tokens[i]);
            moot.setAttributeNode(attrM);
            word.appendChild(moot);
            word.appendChild(doc.createTextNode(tokens[i]));
            sent.appendChild(word);
        }
        attr = doc.createAttribute("next");
        attr.setValue("" + id);
        sent.setAttributeNode(attr);
        root.appendChild(sent);
    }

    public void writeSentence(List<HasWord> tokens, List<CoreLabel> tags, List<TaggedWord> lemmas, int id, Document doc, Element root) {
        Element sent = doc.createElement("s");
        Attr attr = doc.createAttribute("id");
        attr.setValue("" + id);
        sent.setAttributeNode(attr);
        for (int i = 0; i < tokens.size(); ++i) {
            Element word = doc.createElement("w");
            Attr attrW = doc.createAttribute("id");
            attrW.setValue("" + id);
            word.setAttributeNode(attrW);
            attrW = doc.createAttribute("t");
            attrW.setValue("" + tokens.get(i).word());
            word.setAttributeNode(attrW);
            Element moot = doc.createElement("ana");
            Attr attrM = doc.createAttribute("word");
            attrM.setValue("" + tokens.get(i).word());
            moot.setAttributeNode(attrM);
            attrM = doc.createAttribute("pos");
            attrM.setValue("" + tags.get(i).tag());
            moot.setAttributeNode(attrM);
            attrM = doc.createAttribute("lemma");
            attrM.setValue("" + lemmas.get(i).word());
            moot.setAttributeNode(attrM);
            word.appendChild(moot);
            word.appendChild(doc.createTextNode(tokens.get(i).toString()));
            sent.appendChild(word);
        }
        attr = doc.createAttribute("next");
        attr.setValue("" + id);
        sent.setAttributeNode(attr);
        root.appendChild(sent);
    }

    public void writeHeader(String sentence, int id, Document doc, Element root) {
        Element h = doc.createElement("header");
        root.appendChild(h);
    }

    public void write() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("ddc_document");
            Attr attrR = doc.createAttribute("id");
            attrR.setValue("1");
            rootElement.setAttributeNode(attrR);
            this.writeHeader("", 1, doc, rootElement);
            Element textElement = doc.createElement("text");
            doc.appendChild(rootElement);
            rootElement.appendChild(textElement);
            String[] sents = new String[]{"Hello World.", "How are you today?"};
            String s = "Hello World. How are you today? I was there, but it was boring.";
            s = "Dennoch frage ich Dich: Was ist wirklich, die GOtt\u00c3\u00a4hnlichkeit des Menschen oder die Menschen\u00c3\u00a4hnlichkeit GOttes?    Da verdunkelte sich Seine Stirn, und das Licht in der H\u00c3\u00b6he verdunkelte sich, und die Engelchen mit ihren rosa K\u00c3\u00b6pfchen und ihren durchsichtig schimmernden Fl\u00c3\u00bcgelchen schwirrten erregt um die Leiter herum, ganz so, als ob diese in B\u00c3\u00a4lde zusammenst\u00c3\u00bcrzen m\u00c3\u00bc\u00c3\u0178te, und auch ich f\u00c3\u00bcrchtete mich ob meiner Frage.   Die Stimme GOttes aber erhob sich und klang ver\u00c3\u00a4ndert, fast ein wenig kreischend, und sprach: Ob so oder so, was ist es dir, der du weniger bist als der Staub, aus dem Ich den Menschen geschaffen?";
            LexicalizedParser lp = LexicalizedParser.loadModel("edu/stanford/nlp/models/lexparser/germanPCFG.ser.gz", "-maxLength", "200");
            Tree parse = null;
            WordStemmer stemmer = new WordStemmer();
            DocumentPreprocessor dp = new DocumentPreprocessor(new StringReader(s));
            for (List<HasWord> sentence : dp) {
                parse = lp.parse(sentence);
                stemmer.visitTree(parse);
                this.writeSentence(sentence, parse.taggedLabeledYield(), parse.taggedYield(), 2, doc, rootElement);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        try {
            WriteXMLFile wr = new WriteXMLFile();
            wr.write();
            return;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
    }
}

