/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.writer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class WriteCitationLike
extends Operator {
    public static String PARAMETER_ID_ATTR = "id";
    public static String PARAMETER_TITLE_ATTR = "title";
    public static String PARAMETER_AUTHOR_ATTR = "author";
    public static String PARAMETER_SOURCE_ATTR = "source";
    public static String PARAMETER_TEXT_ATTR = "text_attr";
    public static String PARAMETER_PATH = "path";
    public static String PARAMETER_WRITE_TEXT = "write_text";
    private final InputPort input = (InputPort)this.getInputPorts().createPort("example set text documents with additional information");
    private final OutputPort output = (OutputPort)this.getOutputPorts().createPort("example set of input data");
    public static String PARAMETER_DATE_ATTR = "date";

    public String transformPath(String path) {
        if (path.contains("\\")) {
            path = path.replaceAll("\\", "/");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public WriteCitationLike(OperatorDescription description) {
        super(description);
        GenerateNewMDRule n = new GenerateNewMDRule(this.output, ExampleSet.class){

            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                return super.modifyMetaData(unmodifiedMetaData);
            }
        };
        this.getTransformer().addRule((MDTransformationRule)n);
    }

    public void writeAndZip(ArrayList<String> strings, String path, String file) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path, file)), "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            for (String r : strings) {
                bw.write(r);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            int count;
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(new File(path, file + ".zip"));
            ZipOutputStream out2 = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            FileInputStream fi = new FileInputStream(new File(path, file));
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(file.substring(file.lastIndexOf("/") + 1, file.length()));
            out2.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out2.write(data, 0, count);
            }
            origin.close();
            out2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.input.getData(ExampleSet.class);
        Example ex = exampleSet.getExample(0);
        Attributes attr = ex.getAttributes();
        String id_att_name = this.getParameter(PARAMETER_ID_ATTR);
        Attribute id_att = attr.get(id_att_name);
        String title_att_name = this.getParameter(PARAMETER_TITLE_ATTR);
        Attribute title_att = attr.get(title_att_name);
        String author_att_name = this.getParameter(PARAMETER_AUTHOR_ATTR);
        Attribute author_att = attr.get(author_att_name);
        String source_att_name = this.getParameter(PARAMETER_SOURCE_ATTR);
        Attribute source_att = attr.get(source_att_name);
        String date_att_name = this.getParameter(PARAMETER_DATE_ATTR);
        Attribute date_att = attr.get(date_att_name);
        String text_att_name = this.getParameter(PARAMETER_TEXT_ATTR);
        Attribute text_att = attr.get(text_att_name);
        String p = this.getParameterAsFile(PARAMETER_PATH).getPath();
        File theDir = new File(p, "docs");
        if (theDir.exists()) {
            theDir.delete();
        }
        if (!theDir.exists()) {
            System.out.println("creating directory: " + p);
            boolean result = false;
            try {
                theDir.mkdir();
                result = true;
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (result) {
                System.out.println("DIR created");
            }
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < exampleSet.size(); ++i) {
            ex = exampleSet.getExample(i);
            String s = "";
            s = id_att != null ? s + "\"" + (int)ex.getValue(id_att) + "\"," : s + i + ",";
            if (title_att != null) {
                String sTitle = ex.getNominalValue(title_att);
                sTitle = sTitle.replaceAll("[,\n;:\"]", "");
                sTitle = "\"" + sTitle + "\"";
                s = s + sTitle + ",";
            } else {
                s = s + i + ",";
            }
            if (author_att != null) {
                String sAuthor = ex.getNominalValue(author_att);
                sAuthor = sAuthor.replaceAll("[,\n;:\"]", "");
                sAuthor = "\"" + sAuthor + "\"";
                s = s + sAuthor + ",";
            } else {
                s = s + i + ",";
            }
            if (source_att != null) {
                String sSource = ex.getNominalValue(source_att);
                sSource = sSource.replaceAll("[,\n;:\"]", "");
                sSource = "\"" + sSource + "\"";
                s = s + sSource + ",\"1\",\"\",";
            } else {
                System.out.print(i + ",\"1\",\"\",");
                s = s + i + ",\"\",\"\"";
            }
            if (date_att != null) {
                String sDate = null;
                try {
                    sDate = ex.getNominalValue(date_att);
                }
                catch (Exception e) {
                    sDate = String.valueOf((int)ex.getValue(date_att));
                }
                sDate = sDate.replaceAll("[,\n;:\"]", "");
                sDate = sDate.contains("-") ? "\"" + sDate + "-01T00:00:00Z\"" : "\"" + sDate + "-01-01T00:00:00Z\"";
                s = s + sDate + ",\"\",\"\"";
            } else {
                System.out.print(i + ",\"\",\"\"");
                s = s + i + ",\"\",\"\"";
            }
            strings.add(s + "\n");
            boolean write = this.getParameterAsBoolean(PARAMETER_WRITE_TEXT);
            if (!write) continue;
            String text = ex.getNominalValue(text_att);
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(p, "docs/" + (int)ex.getValue(id_att) + ".html")));
                bw.write("<html><head><meta charset=\"utf-8\"/><title>" + (int)ex.getValue(id_att) + "</title></head><body><p>T" + text + "</p></body></html>");
                bw.close();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.writeAndZip(strings, p, "meta.csv");
        this.output.deliver((IOObject)exampleSet);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ID_ATTR, "Attribute name of id column in the input example.", ""));
        types.add(new ParameterTypeString(PARAMETER_TITLE_ATTR, "Attribute name of title column in the input example.", ""));
        types.add(new ParameterTypeString(PARAMETER_AUTHOR_ATTR, "Attribute name of author column in the input examples.", ""));
        types.add(new ParameterTypeString(PARAMETER_SOURCE_ATTR, "Attribute name of document source column in the input examples.", ""));
        types.add(new ParameterTypeString(PARAMETER_DATE_ATTR, "Attribute name of date column in the input example.", ""));
        types.add(new ParameterTypeString(PARAMETER_TEXT_ATTR, "Attribute name of text column in the input example.", ""));
        types.add(new ParameterTypeDirectory(PARAMETER_PATH, "Path for dfr files to be written.", "/home/poelitz/work/Datasets/ResultData/acl2015"));
        types.add(new ParameterTypeBoolean(PARAMETER_WRITE_TEXT, "Write text results out for dfr browser", true, false));
        return types;
    }
}

