/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.writer;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.text.Token;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.io.Encoding;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.WordStemmer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TEIWriter
extends Operator {
    private static final String PARAMETER_FILE = "file";
    private static final String PARAMETER_OVERWRITE = "overwrite";
    private InputPort textObjectInput = this.getInputPorts().createPort("document", com.rapidminer.operator.text.Document.class);
    private OutputPort textObjectOutput = (OutputPort)this.getOutputPorts().createPort("document");
    LexicalizedParser lp = null;
    int id = 1;

    public TEIWriter(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.textObjectInput, this.textObjectOutput);
        this.lp = LexicalizedParser.loadModel("/home/poelitz/Downloads/stanford-parser-full-2014-01-04/edu/stanford/nlp/models/lexparser/germanPCFG.ser.gz", "-maxLength", "200");
    }

    public void writeHeader(String sentence, int id, Document doc, Element root) {
        Element h = doc.createElement("header");
        root.appendChild(h);
    }

    public void writeSentence(List<HasWord> tokens, List<CoreLabel> tags, List<TaggedWord> lemmas, int id, Document doc, Element root) {
        Element sent = doc.createElement("s");
        Attr attr = doc.createAttribute("id");
        attr.setValue("" + id);
        sent.setAttributeNode(attr);
        for (int i = 0; i < tokens.size(); ++i) {
            Element word = doc.createElement("w");
            Attr attrW = doc.createAttribute("id");
            attrW.setValue("" + id);
            word.setAttributeNode(attrW);
            attrW = doc.createAttribute("t");
            attrW.setValue("" + tokens.get(i).word());
            word.setAttributeNode(attrW);
            Element moot = doc.createElement("ana");
            Attr attrM = doc.createAttribute("word");
            attrM.setValue("" + tokens.get(i).word());
            moot.setAttributeNode(attrM);
            attrM = doc.createAttribute("pos");
            attrM.setValue("" + tags.get(i).tag());
            moot.setAttributeNode(attrM);
            attrM = doc.createAttribute("lemma");
            attrM.setValue("" + lemmas.get(i).word());
            moot.setAttributeNode(attrM);
            word.appendChild(moot);
            word.appendChild(doc.createTextNode(tokens.get(i).toString()));
            sent.appendChild(word);
        }
        attr = doc.createAttribute("next");
        attr.setValue("" + id);
        sent.setAttributeNode(attr);
        root.appendChild(sent);
    }

    public Document write(String text, int id) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("ddc_document");
            Attr attrR = doc.createAttribute("id");
            attrR.setValue("1");
            rootElement.setAttributeNode(attrR);
            this.writeHeader("", 1, doc, rootElement);
            Element textElement = doc.createElement("text");
            doc.appendChild(rootElement);
            rootElement.appendChild(textElement);
            String s = text;
            Tree parse = null;
            WordStemmer stemmer = new WordStemmer();
            DocumentPreprocessor dp = new DocumentPreprocessor(new StringReader(s));
            int nextId = 0;
            for (List<HasWord> sentence : dp) {
                parse = this.lp.parse(sentence);
                stemmer.visitTree(parse);
                this.writeSentence(sentence, parse.taggedLabeledYield(), parse.taggedYield(), nextId++, doc, rootElement);
            }
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void doWork() throws OperatorException {
        com.rapidminer.operator.text.Document text = (com.rapidminer.operator.text.Document)this.textObjectInput.getData(com.rapidminer.operator.text.Document.class);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.write(text.getText(), this.id++));
            StringWriter sWriter = new StringWriter();
            StreamResult result = new StreamResult(sWriter);
            transformer.transform(source, result);
            Token tok = new Token(sWriter.getBuffer().toString(), 1.0f);
            text.getTokenSequence().clear();
            text.getTokenSequence().add(tok);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        this.textObjectOutput.deliver((IOObject)text);
    }

    public List<ParameterType> getParameterTypes() {
        List parameters = super.getParameterTypes();
        ParameterTypeBoolean overwriteParam = new ParameterTypeBoolean(PARAMETER_OVERWRITE, "Specifies if an existing file with given name should be overwritten.", true);
        parameters.add(overwriteParam);
        parameters.addAll(Encoding.getParameterTypes((ParameterHandler)this));
        return parameters;
    }
}

