/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.RandomGenerator;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TemporalCoherenceEvaluationOperator
extends Operator {
    static String PARAMETER_NUMITERATIONS = "iterations";
    static String PARAMETER_NUMTOPICS = "number_of_topics";
    static String PARAMETER_NUMTESTS = "tests";
    static String PARAMETER_ALPHA = "alpha";
    static String PARAMETER_TEXT_ATTRIBUTE = "text_attribute";
    static String PARAMETER_GAMMA = "smooting_gamma";
    static String PARAMETER_SUPER = "supervised";
    int iters = 2000;
    int numTopics = 4;
    double alpha = 0.25;
    double maxTime = 0.0;
    private final InputPort input = (InputPort)this.getInputPorts().createPort("example set input");
    private final InputPort inputWords = (InputPort)this.getInputPorts().createPort("example set words");
    private final InputPort inputTimes = (InputPort)this.getInputPorts().createPort("example set times");
    private final OutputPort output = (OutputPort)this.getOutputPorts().createPort("output neg log likelihoods");
    Random rn = null;

    public TemporalCoherenceEvaluationOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        this.iters = this.getParameterAsInt(PARAMETER_NUMITERATIONS);
        this.numTopics = this.getParameterAsInt(PARAMETER_NUMTOPICS);
        this.alpha = this.getParameterAsDouble(PARAMETER_ALPHA);
        int numTests = this.getParameterAsInt(PARAMETER_NUMTESTS);
        double gamma = this.getParameterAsDouble(PARAMETER_GAMMA);
        boolean locSeed = this.getParameterAsBoolean("use_local_random_seed");
        int seed = this.getParameterAsInt("local_random_seed");
        this.rn = locSeed ? new Random(seed) : new Random();
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(AttributeFactory.createAttribute((String)"negloglikelihood", (int)2));
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        int numWords = 0;
        ExampleSet exampleSet = (ExampleSet)this.input.getData(ExampleSet.class);
        Example ex = exampleSet.getExample(0);
        Attributes attr = ex.getAttributes();
        TIntArrayList[] documentTokens = new TIntArrayList[exampleSet.size()];
        Attribute textAttribute = null;
        String colName = this.getParameterAsString(PARAMETER_TEXT_ATTRIBUTE);
        for (Attribute att : attr) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(att.getValueType(), 5)) continue;
            if (colName.equals("")) {
                textAttribute = att;
                continue;
            }
            if (!colName.equals(att.getName())) continue;
            textAttribute = att;
        }
        double[] labels = null;
        TDoubleArrayList times = new TDoubleArrayList();
        if (textAttribute != null) {
            TObjectIntHashMap<String> attToId = new TObjectIntHashMap<String>();
            ex = exampleSet.getExample(0);
            attr = ex.getAttributes();
            int id = 0;
            for (Attribute att : attr) {
                if (att == textAttribute) continue;
                attToId.put(att.getName().trim().toLowerCase(), id);
                ++id;
            }
            for (int i = 0; i < exampleSet.size(); ++i) {
                ex = exampleSet.getExample(i);
                attr = ex.getAttributes();
                String text = ex.getValueAsString(textAttribute);
                String[] tokens = text.split(" ");
                documentTokens[i] = new TIntArrayList();
                for (String token : tokens) {
                    if (!attToId.contains(token.trim().toLowerCase())) continue;
                    documentTokens[i].add(attToId.get(token.trim().toLowerCase()));
                }
            }
        } else {
            if (attr.getLabel() != null) {
                labels = new double[exampleSet.size()];
            }
            for (int i = 0; i < exampleSet.size(); ++i) {
                documentTokens[i] = new TIntArrayList();
                ex = exampleSet.getExample(i);
                attr = ex.getAttributes();
                if (attr.getLabel() != null) {
                    labels[i] = ex.getLabel();
                    times.add(labels[i]);
                    if (labels[i] > this.maxTime) {
                        this.maxTime = labels[i];
                    }
                }
                int j = 0;
                for (Attribute att : attr) {
                    double frequ = 0.0;
                    frequ = ex.getValue(att);
                    if (frequ != 0.0) {
                        for (int k = 0; k < (int)frequ; ++k) {
                            documentTokens[i].add(j);
                        }
                    }
                    ++j;
                }
                documentTokens[i].shuffle(this.rn);
            }
        }
        ExampleSet examplesProbs = (ExampleSet)this.inputWords.getData(ExampleSet.class);
        Example ex2 = examplesProbs.getExample(0);
        Attributes atts = ex.getAttributes();
        numWords = examplesProbs.size();
        double[][] topicassigns = new double[numWords][this.numTopics];
        for (int i = 0; i < examplesProbs.size(); ++i) {
            ex2 = examplesProbs.getExample(i);
            atts = ex2.getAttributes();
            int j = 0;
            for (Attribute att : atts) {
                if (!att.getName().contains("Topic_") && !att.getName().contains("svd_")) continue;
                topicassigns[i][j] = ex2.getValue(att);
                ++j;
            }
        }
        int[][] top2 = new int[this.numTopics][2];
        TDoubleArrayList[] temps = new TDoubleArrayList[this.numTopics];
        TDoubleArrayList[] tempsTopics = new TDoubleArrayList[this.numTopics];
        double perplexity = 0.0;
        int allCounts = 0;
        for (int i = 0; i < documentTokens.length; ++i) {
            TIntArrayList list = documentTokens[i];
            for (int t = 0; t < this.numTopics; ++t) {
                if (!list.contains(top2[t][0]) || !list.contains(top2[t][0])) continue;
                double nextTime = labels[i];
                temps[t].add(nextTime);
            }
        }
        System.out.println(allCounts);
        System.out.println(perplexity);
        DataRow row = factory.create(table.getNumberOfAttributes());
        table.addDataRow(row);
        row.set((Attribute)attributeList.get(0), perplexity);
        SimpleExampleSet set = new SimpleExampleSet((ExampleTable)table);
        this.output.deliver((IOObject)set);
    }

    public double minCos(double[] x, double[][] Y) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < Y.length; ++i) {
            double tmp = this.cos(x, Y[i]);
            if (!(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public double sumCos(double[] x, double[][] Y) {
        double sum = 0.0;
        for (int i = 0; i < Y.length; ++i) {
            sum += this.cos(x, Y[i]);
        }
        return sum;
    }

    public double cos(double[] x, double[] y) {
        double nx = 0.0;
        double ny = 0.0;
        double dot = 0.0;
        for (int i = 0; i < x.length; ++i) {
            nx += x[i] * x[i];
            ny += y[i] * y[i];
            dot += x[i] * y[i];
        }
        nx = Math.sqrt(nx);
        ny = Math.sqrt(ny);
        return dot / (nx * ny);
    }

    public int[] getDiscrete(int num, double[] probs) {
        int i;
        double sum = 0.0;
        for (i = 0; i < probs.length; ++i) {
            sum += probs[i];
        }
        i = 0;
        while (i < probs.length) {
            int n = i++;
            probs[n] = probs[n] / sum;
        }
        double pr = 0.0;
        int[] res = new int[num];
        for (int i2 = 0; i2 < num; ++i2) {
            int j = 0;
            double p = this.rn.nextDouble();
            for (pr = probs[0]; pr < p; pr += probs[++j]) {
            }
            res[i2] = j;
        }
        return res;
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMITERATIONS, "Number of Iterations for Samplings.", 1, Integer.MAX_VALUE, 2000));
        types.add(new ParameterTypeInt(PARAMETER_NUMTESTS, "Number of Iterations for Samplings.", 1, Integer.MAX_VALUE, 20));
        types.add(new ParameterTypeInt(PARAMETER_NUMTOPICS, "Number of Topics.", 1, Integer.MAX_VALUE, 5));
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "Alpha", 0.0, Double.MAX_VALUE, 0.25));
        types.add(new ParameterTypeString(PARAMETER_TEXT_ATTRIBUTE, "Attribute name of text columns of interest.", ""));
        types.add(new ParameterTypeDouble(PARAMETER_GAMMA, "Gamma", 0.0, Double.MAX_VALUE, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_SUPER, "Perform supervised LDA with numinal (Gaussian) or numeric (Beta) labels. ", false, false));
        types.addAll(RandomGenerator.getRandomGeneratorParameters((Operator)this));
        return types;
    }

    public static void main(String[] args) {
    }
}

