/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.kobra.topicmodels.SamplersGTLDA;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TDoubleIntHashMap;

public class SamplersUniformTLDA
extends SamplersGTLDA {
    @Override
    public double dist(double x, double a, double b) {
        return 1.0 / this.maxTime;
    }

    @Override
    public void GibbsSampling() {
        int burnIn = (int)((double)this.maxIter * 0.9);
        int topic = 0;
        this.WBETA = (double)this.numWords * this.BETA;
        this.probs = new double[this.numTopics];
        this.tokenToTopic = new int[this.numTokens];
        TIntArrayList ll = new TIntArrayList(this.numTokens);
        for (int i = 0; i < this.numTokens; ++i) {
            ll.add(i);
        }
        ll.shuffle(this.rn);
        this.testStatistics = new double[this.maxIter][this.numTopics];
        this.hsValues = new TDoubleIntHashMap[this.numTopics];
        for (int iter = 0; iter < this.maxIter; ++iter) {
            int i;
            System.out.println("Current Gibbs Sampler iteration: " + iter);
            for (i = 0; i < this.numTopics; ++i) {
                this.hsValues[i] = new TDoubleIntHashMap();
            }
            for (int ii = 0; ii < this.numTokens; ++ii) {
                int i2 = ll.get(ii);
                int wi = this.words[i2];
                int di = this.docs[i2];
                int n = topic = this.topics[i2];
                this.topiccounts[n] = this.topiccounts[n] - 1;
                int wioffset = wi * this.numTopics;
                int dioffset = di * this.numTopics;
                int n2 = wioffset + topic;
                this.wordtopiccounts[n2] = this.wordtopiccounts[n2] - 1;
                int n3 = dioffset + topic;
                this.doctopiccounts[n3] = this.doctopiccounts[n3] - 1;
                double totprob = 0.0;
                for (int j = 0; j < this.numTopics; ++j) {
                    this.probs[j] = ((double)this.wordtopiccounts[wioffset + j] + this.BETA) / ((double)this.topiccounts[j] + this.WBETA) * ((double)this.doctopiccounts[dioffset + j] + this.ALPHA) * this.dist(this.times[di], this.pGombertz[j][0], this.pGombertz[j][1]);
                    totprob += this.probs[j];
                }
                double r = totprob * this.rn.nextDouble();
                topic = 0;
                for (double max = this.probs[0]; r > max; max += this.probs[++topic]) {
                }
                this.topics[i2] = topic;
                int n4 = wioffset + topic;
                this.wordtopiccounts[n4] = this.wordtopiccounts[n4] + 1;
                int n5 = dioffset + topic;
                this.doctopiccounts[n5] = this.doctopiccounts[n5] + 1;
                int n6 = topic;
                this.topiccounts[n6] = this.topiccounts[n6] + 1;
                int n7 = 1;
                if (this.hsValues[topic].contains(this.times[di])) {
                    n7 += this.hsValues[topic].get(this.times[di]);
                }
                this.hsValues[topic].put(this.times[di], n7);
                this.tokenToTopic[ii] = topic;
            }
            for (i = 0; i < this.numWords * this.numTopics; ++i) {
                if (this.wordtopiccounts[i] >= 0) continue;
                this.wordtopiccounts[i] = 0;
            }
            for (i = 0; i < this.numDocs * this.numTopics; ++i) {
                if (this.doctopiccounts[i] >= 0) continue;
                this.doctopiccounts[i] = 0;
            }
            if (iter < burnIn || iter % 2 != 0) continue;
            this.updateDistributions();
        }
    }
}

