/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.kobra.topicmodels.SamplersLDA;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.distribution.MixtureMultivariateNormalDistribution;
import org.apache.commons.math3.distribution.MultivariateNormalDistribution;
import org.apache.commons.math3.distribution.fitting.MultivariateNormalMixtureExpectationMaximization;

public class SamplersSupervisedLDA
extends SamplersLDA {
    double[][] z_bar;
    int[] doc_lengths;
    double[][] labels;
    public Random rn = null;
    ArrayList<double[]>[] labels_topic = null;
    double[][] pi = null;
    MixtureMultivariateNormalDistribution[] nd = null;

    public void init(int[] docIds, int[] wordIds, int numTopics, int numWords, int numDocs, int iter, double beta, double alpha, double[][] labels, int[] doc_lengths, boolean locSeed, int seed) {
        int i;
        this.labels = labels;
        this.doc_lengths = doc_lengths;
        this.maxIter = iter;
        this.BETA = beta;
        this.ALPHA = alpha;
        int topic = 0;
        this.numTokens = wordIds.length;
        this.numTopics = numTopics;
        this.numDocs = numDocs;
        this.numWords = numWords;
        this.topics = new int[this.numTokens];
        this.wordtopiccounts = new int[numWords * numTopics];
        this.doctopiccounts = new int[numDocs * numTopics];
        this.topiccounts = new int[numTopics];
        this.words = wordIds;
        this.docs = docIds;
        if (locSeed) {
            this.seed = seed;
            this.rn = new Random(seed);
        } else {
            this.rn = new Random();
        }
        this.labels_topic = new ArrayList[numTopics];
        for (i = 0; i < numTopics; ++i) {
            this.labels_topic[i] = new ArrayList();
        }
        for (i = 0; i < wordIds.length; ++i) {
            int wi = this.words[i];
            int di = this.docs[i];
            this.topics[i] = topic = this.rn.nextInt(numTopics);
            int n = wi * numTopics + topic;
            this.wordtopiccounts[n] = this.wordtopiccounts[n] + 1;
            int n2 = di * numTopics + topic;
            this.doctopiccounts[n2] = this.doctopiccounts[n2] + 1;
            int n3 = topic;
            this.topiccounts[n3] = this.topiccounts[n3] + 1;
            this.labels_topic[topic].add(labels[di]);
        }
    }

    @Override
    public void GibbsSampling() {
        int burnIn = (int)((double)this.maxIter * 0.9);
        int topic = 0;
        this.WBETA = (double)this.numWords * this.BETA;
        this.probs = new double[this.numTopics];
        this.tokenToTopic = new int[this.numTokens];
        TIntArrayList ll = new TIntArrayList(this.numTokens);
        for (int i = 0; i < this.numTokens; ++i) {
            ll.add(i);
        }
        ll.shuffle(this.rn);
        double[] eta = new double[this.numTopics];
        for (int j = 0; j < this.numTopics; ++j) {
            eta[j] = 1.0 / (double)this.numTopics;
        }
        this.nd = new MixtureMultivariateNormalDistribution[this.numTopics];
        int dim = this.labels[0].length;
        for (int i = 0; i < this.numTopics; ++i) {
            double[][] data = (double[][])this.labels_topic[i].toArray((T[])new double[0][]);
            this.nd[i] = MultivariateNormalMixtureExpectationMaximization.estimate((double[][])this.labels_topic[i].toArray((T[])new double[0][]), 2);
        }
        this.pi = new double[this.numTopics][2];
        for (int iter = 0; iter < this.maxIter; ++iter) {
            int i;
            this.z_bar = new double[this.numDocs][this.numTopics];
            for (i = 0; i < this.numTopics; ++i) {
                this.labels_topic[i].clear();
            }
            for (int ii = 0; ii < this.numTokens; ++ii) {
                int i2 = ll.get(ii);
                int wi = this.words[i2];
                int di = this.docs[i2];
                int n = topic = this.topics[i2];
                this.topiccounts[n] = this.topiccounts[n] - 1;
                int wioffset = wi * this.numTopics;
                int dioffset = di * this.numTopics;
                int n2 = wioffset + topic;
                this.wordtopiccounts[n2] = this.wordtopiccounts[n2] - 1;
                int n3 = dioffset + topic;
                this.doctopiccounts[n3] = this.doctopiccounts[n3] - 1;
                double totprob = 0.0;
                for (int j = 0; j < this.numTopics; ++j) {
                    double normal = this.nd[j].density(this.labels[di]);
                    this.probs[j] = ((double)this.wordtopiccounts[wioffset + j] + this.BETA) / ((double)this.topiccounts[j] + this.WBETA) * ((double)this.doctopiccounts[dioffset + j] + this.ALPHA) * normal;
                    totprob += this.probs[j];
                }
                double r = totprob * this.rn.nextDouble();
                topic = 0;
                for (double max = this.probs[0]; r > max; max += this.probs[++topic]) {
                }
                this.topics[i2] = topic;
                int n4 = wioffset + topic;
                this.wordtopiccounts[n4] = this.wordtopiccounts[n4] + 1;
                int n5 = dioffset + topic;
                this.doctopiccounts[n5] = this.doctopiccounts[n5] + 1;
                int n6 = topic;
                this.topiccounts[n6] = this.topiccounts[n6] + 1;
                this.labels_topic[topic].add(this.labels[di]);
                this.tokenToTopic[ii] = topic;
            }
            for (i = 0; i < this.numWords * this.numTopics; ++i) {
                if (this.wordtopiccounts[i] >= 0) continue;
                this.wordtopiccounts[i] = 0;
            }
            for (i = 0; i < this.numDocs * this.numTopics; ++i) {
                if (this.doctopiccounts[i] >= 0) continue;
                this.doctopiccounts[i] = 0;
            }
            if (iter >= burnIn && iter % 2 == 0) {
                this.updateDistributions();
            }
            if (iter != 0 && iter % 10 != 0 || iter >= burnIn) continue;
            for (i = 0; i < this.numTopics; ++i) {
                this.nd[i] = MultivariateNormalMixtureExpectationMaximization.estimate((double[][])this.labels_topic[i].toArray((T[])new double[0][]), 2);
                ((MultivariateNormalDistribution)this.nd[i].getComponents().get(0).getSecond()).getMeans();
                ((MultivariateNormalDistribution)this.nd[i].getComponents().get(0).getSecond()).getStandardDeviations();
                ((MultivariateNormalDistribution)this.nd[i].getComponents().get(0).getSecond()).getCovariances().getData();
            }
        }
    }

    public double[][] getMeans() {
        double[][] res = new double[this.numTopics][];
        for (int i = 0; i < this.numTopics; ++i) {
            res[i] = ((MultivariateNormalDistribution)this.nd[i].getComponents().get(0).getSecond()).getMeans();
        }
        return res;
    }

    public double[][] getStdDev() {
        double[][] res = new double[this.numTopics][];
        for (int i = 0; i < this.numTopics; ++i) {
            res[i] = ((MultivariateNormalDistribution)this.nd[i].getComponents().get(0).getSecond()).getStandardDeviations();
        }
        return res;
    }

    public double[][][] getCov() {
        double[][][] res = new double[this.numTopics][][];
        for (int i = 0; i < this.numTopics; ++i) {
            res[i] = ((MultivariateNormalDistribution)this.nd[i].getComponents().get(0).getSecond()).getCovariances().getData();
        }
        return res;
    }

    public double[][] getPi() {
        return this.pi;
    }

    public static void main(String[] args) {
    }
}

