/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;

public class SamplersLLDA {
    int[] words;
    int[] docs;
    int[] topics;
    int[] wordtopiccounts;
    int[] doctopiccounts;
    int[] topiccounts;
    int numTokens = 0;
    int numTopics = 4;
    int maxIter = 1000;
    int numWords;
    int numDocs;
    int[][] labels;
    double BETA = 0.1;
    double ALPHA = 0.25;
    double WBETA;
    double[] probs;
    int[] tokenToTopic = null;
    double[][] phi = null;
    double[][] theta = null;
    int numStats = 0;

    public void init(int[] docIds, int[] wordIds, int numTopics, int numWords, int numDocs, int iter, double beta, double alpha) {
        this.maxIter = iter;
        this.BETA = beta;
        this.ALPHA = alpha;
        int topic = 0;
        this.numTokens = wordIds.length;
        this.numTopics = numTopics;
        this.numDocs = numDocs;
        this.numWords = numWords;
        this.topics = new int[this.numTokens];
        this.wordtopiccounts = new int[numWords * numTopics];
        this.doctopiccounts = new int[numDocs * numTopics];
        this.topiccounts = new int[numTopics];
        this.words = wordIds;
        this.docs = docIds;
        for (int i = 0; i < wordIds.length; ++i) {
            int wi = this.words[i];
            int di = this.docs[i];
            this.topics[i] = topic = new Random().nextInt(numTopics);
            int n = wi * numTopics + topic;
            this.wordtopiccounts[n] = this.wordtopiccounts[n] + 1;
            int n2 = di * numTopics + topic;
            this.doctopiccounts[n2] = this.doctopiccounts[n2] + 1;
            int n3 = topic;
            this.topiccounts[n3] = this.topiccounts[n3] + 1;
        }
    }

    public int[] getTokenToTopic() {
        return this.tokenToTopic;
    }

    public void GibbsSampling() {
        int burnIn = (int)((double)this.maxIter * 0.9);
        int topic = 0;
        this.WBETA = (double)this.numWords * this.BETA;
        this.probs = new double[this.numTopics];
        this.tokenToTopic = new int[this.numTokens];
        TIntArrayList ll = new TIntArrayList(this.numTokens);
        for (int i = 0; i < this.numTokens; ++i) {
            ll.add(i);
        }
        ll.shuffle(new Random(2000L));
        for (int iter = 0; iter < this.maxIter; ++iter) {
            int i;
            for (int ii = 0; ii < this.numTokens; ++ii) {
                int j;
                int i2 = ll.get(ii);
                int wi = this.words[i2];
                int di = this.docs[i2];
                int n = topic = this.topics[i2];
                this.topiccounts[n] = this.topiccounts[n] - 1;
                int wioffset = wi * this.numTopics;
                int dioffset = di * this.numTopics;
                int n2 = wioffset + topic;
                this.wordtopiccounts[n2] = this.wordtopiccounts[n2] - 1;
                int n3 = dioffset + topic;
                this.doctopiccounts[n3] = this.doctopiccounts[n3] - 1;
                double totprob = 0.0;
                int docCounts = 0;
                for (j = 0; j < this.numTopics; ++j) {
                    docCounts += this.doctopiccounts[dioffset + j];
                }
                for (j = 0; j < this.numTopics; ++j) {
                    this.probs[j] = ((double)this.wordtopiccounts[wioffset + j] + this.BETA) / ((double)this.topiccounts[j] + this.WBETA) * ((double)this.doctopiccounts[dioffset + j] + this.ALPHA);
                    totprob += this.probs[j];
                }
                double r = totprob * Math.random();
                topic = 0;
                for (double max = this.probs[0]; r > max; max += this.probs[++topic]) {
                }
                this.topics[i2] = topic;
                int n4 = wioffset + topic;
                this.wordtopiccounts[n4] = this.wordtopiccounts[n4] + 1;
                int n5 = dioffset + topic;
                this.doctopiccounts[n5] = this.doctopiccounts[n5] + 1;
                int n6 = topic;
                this.topiccounts[n6] = this.topiccounts[n6] + 1;
                this.tokenToTopic[ii] = topic;
            }
            for (i = 0; i < this.numWords * this.numTopics; ++i) {
                if (this.wordtopiccounts[i] >= 0) continue;
                this.wordtopiccounts[i] = 0;
            }
            for (i = 0; i < this.numDocs * this.numTopics; ++i) {
                if (this.doctopiccounts[i] >= 0) continue;
                this.doctopiccounts[i] = 0;
            }
            if (iter < burnIn || iter % 2 != 0) continue;
            this.updateDistributions();
        }
    }

    public int[] assignedTopicsToWords() {
        int[] res = new int[this.numWords];
        double max = 0.0;
        for (int i = 0; i < this.numWords; ++i) {
            max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (!(max < (double)this.wordtopiccounts[i * this.numTopics + j])) continue;
                max = this.wordtopiccounts[i * this.numTopics + j];
                res[i] = j;
            }
        }
        return res;
    }

    public void updateDistributions() {
        ++this.numStats;
        this.updateWordDistribution();
        this.updateDocumentDistribution();
    }

    public void updateWordDistribution() {
        if (this.theta == null) {
            this.theta = new double[this.numTopics][this.numWords];
        }
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < this.numTopics; ++j) {
                double[] dArray = this.theta[j];
                int n = i;
                dArray[n] = dArray[n] + ((double)this.wordtopiccounts[i * this.numTopics + j] + this.BETA) / ((double)this.topiccounts[j] + (double)this.numWords * this.BETA);
            }
        }
    }

    public void updateDocumentDistribution() {
        if (this.phi == null) {
            this.phi = new double[this.numTopics][this.numDocs];
        }
        for (int i = 0; i < this.numDocs; ++i) {
            int j;
            int docCounts = 0;
            for (j = 0; j < this.numTopics; ++j) {
                docCounts += this.doctopiccounts[i * this.numTopics + j];
            }
            for (j = 0; j < this.numTopics; ++j) {
                double[] dArray = this.phi[j];
                int n = i;
                dArray[n] = dArray[n] + ((double)this.doctopiccounts[i * this.numTopics + j] + this.ALPHA) / ((double)docCounts + (double)this.numTopics * this.ALPHA);
            }
        }
    }

    public double[][] wordDistribution() {
        double[][] res = new double[this.numTopics][this.numWords];
        if (this.numStats > 0) {
            for (int i = 0; i < this.numWords; ++i) {
                for (int j = 0; j < this.numTopics; ++j) {
                    res[j][i] = this.theta[j][i] / (double)this.numStats;
                }
            }
            return res;
        }
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < this.numTopics; ++j) {
                res[j][i] = ((double)this.wordtopiccounts[i * this.numTopics + j] + this.BETA) / ((double)this.topiccounts[j] + (double)this.numWords * this.BETA);
            }
        }
        return res;
    }

    public double[][] documentDistribution() {
        double[][] res = new double[this.numTopics][this.numDocs];
        if (this.numStats > 0) {
            for (int i = 0; i < this.numDocs; ++i) {
                for (int j = 0; j < this.numTopics; ++j) {
                    res[j][i] = this.phi[j][i] / (double)this.numStats;
                }
            }
            return res;
        }
        for (int i = 0; i < this.numDocs; ++i) {
            int j;
            int docCounts = 0;
            for (j = 0; j < this.numTopics; ++j) {
                docCounts += this.doctopiccounts[i * this.numTopics + j];
            }
            for (j = 0; j < this.numTopics; ++j) {
                res[j][i] = ((double)this.doctopiccounts[i * this.numTopics + j] + this.ALPHA) / ((double)docCounts + (double)this.numTopics * this.ALPHA);
            }
        }
        return res;
    }

    public double[] assignedTopicsToWordsProbs() {
        double[] res = new double[this.numWords];
        double max = 0.0;
        for (int i = 0; i < this.numWords; ++i) {
            max = 0.0;
            double s = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                s += (double)this.wordtopiccounts[i * this.numTopics + j];
                if (!(max < (double)this.wordtopiccounts[i * this.numTopics + j])) continue;
                max = this.wordtopiccounts[i * this.numTopics + j];
                res[i] = this.wordtopiccounts[i * this.numTopics + j];
            }
        }
        return res;
    }

    public int[] assignedTopicsToDocs() {
        int[] res = new int[this.numDocs];
        double max = 0.0;
        for (int i = 0; i < this.numDocs; ++i) {
            max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (!(max < (double)this.doctopiccounts[i * this.numTopics + j])) continue;
                max = this.doctopiccounts[i * this.numTopics + j];
                res[i] = j;
            }
        }
        return res;
    }

    public static void main(String[] args) {
    }
}

