/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.OptimizationException;
import cc.mallet.optimize.Optimizer;
import com.rapidminer.kobra.opt.MyOrthantWiseLimitedMemoryBFGS;
import com.rapidminer.kobra.topicmodels.MyWordFeatOptimizable;
import com.rapidminer.kobra.topicmodels.SamplersLDA;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;

public class SamplersLDAWordFeatures
extends SamplersLDA {
    boolean reg = false;
    TIntArrayList[] Phi;
    public double[] p_v;
    double[] y_v;
    double[] y_kv;
    public double LAMBDA = 0.1;
    public double GAMMA = 1.0;
    double[] b = null;
    double[] WBETAs = null;
    double[] tmp_b = null;
    double[] paras = null;
    double[][] parameters = null;

    @Override
    public void init(int[] docIds, int[] wordIds, int numTopics, int numWords, int numDocs, int iter, double beta, double alpha, boolean locSeed, int seed) {
        int i;
        this.maxIter = iter;
        this.BETA = beta;
        this.ALPHA = alpha;
        int topic = 0;
        this.numTokens = wordIds.length;
        this.numTopics = numTopics;
        this.numDocs = numDocs;
        this.numWords = numWords;
        this.topics = new int[this.numTokens];
        this.wordtopiccounts = new int[numWords * numTopics];
        this.doctopiccounts = new int[numDocs * numTopics];
        this.topiccounts = new int[numTopics];
        this.words = wordIds;
        this.docs = docIds;
        this.b = new double[numTopics * numWords];
        this.paras = new double[numTopics * numWords];
        this.parameters = new double[numTopics][numWords];
        if (this.p_v == null) {
            this.p_v = new double[numWords];
            for (i = 0; i < numWords; ++i) {
                this.p_v[i] = this.BETA;
            }
        }
        if (locSeed) {
            this.seed = seed;
            this.rn = new Random(seed);
        } else {
            this.rn = new Random();
        }
        for (i = 0; i < numWords; ++i) {
            for (int j = 0; j < numTopics; ++j) {
                this.paras[i * numTopics + j] = 2.0 * this.rn.nextDouble() * this.LAMBDA - this.LAMBDA;
                this.parameters[j][i] = 2.0 * this.rn.nextDouble() * this.LAMBDA - this.LAMBDA;
                this.b[i * numTopics + j] = Math.exp(this.parameters[j][i]) * this.p_v[j];
            }
        }
        for (i = 0; i < wordIds.length; ++i) {
            int wi = this.words[i];
            int di = this.docs[i];
            this.topics[i] = topic = this.rn.nextInt(numTopics);
            int n = wi * numTopics + topic;
            this.wordtopiccounts[n] = this.wordtopiccounts[n] + 1;
            int n2 = di * numTopics + topic;
            this.doctopiccounts[n2] = this.doctopiccounts[n2] + 1;
            int n3 = topic;
            this.topiccounts[n3] = this.topiccounts[n3] + 1;
        }
    }

    public void setReg(boolean r) {
        this.reg = r;
    }

    @Override
    public void GibbsSampling() {
        int burnIn = (int)((double)this.maxIter * 0.9);
        int topic = 0;
        this.WBETA = (double)this.numWords * this.BETA;
        this.WBETAs = new double[this.numTopics];
        for (int i = 0; i < this.numTopics; ++i) {
            this.WBETAs[i] = 0.0;
            for (int j = 0; j < this.numWords; ++j) {
                int n = i;
                this.WBETAs[n] = this.WBETAs[n] + this.b[j * this.numTopics + i];
            }
        }
        this.probs = new double[this.numTopics];
        this.tokenToTopic = new int[this.numTokens];
        TIntArrayList ll = new TIntArrayList(this.numTokens);
        for (int i = 0; i < this.numTokens; ++i) {
            ll.add(i);
        }
        ll.shuffle(new Random(2000L));
        for (int iter = 0; iter < this.maxIter; ++iter) {
            int i;
            if (iter > this.maxIter / 5 && iter % 10 == 0 && iter < burnIn) {
                MyWordFeatOptimizable optimizable = new MyWordFeatOptimizable(this.numTopics, this.numWords, this.rn);
                if (this.reg) {
                    // empty if block
                }
                optimizable.Phi = this.Phi;
                if (this.p_v != null) {
                    optimizable.p_v = this.p_v;
                }
                optimizable.n_kv = this.wordtopiccounts;
                optimizable.n_k = this.topiccounts;
                optimizable.lambda = this.LAMBDA;
                optimizable.sigma = this.LAMBDA;
                optimizable.parameters = this.parameters;
                Optimizer optimizer = null;
                optimizer = !this.reg ? new LimitedMemoryBFGS(optimizable) : new MyOrthantWiseLimitedMemoryBFGS(optimizable, this.GAMMA);
                boolean converged = false;
                try {
                    converged = optimizer.optimize(1000000);
                }
                catch (OptimizationException e) {
                    e.printStackTrace();
                }
                try {
                    converged = optimizer.optimize(1000000);
                }
                catch (OptimizationException e) {
                    e.printStackTrace();
                }
                this.paras = new double[this.numTopics * this.numWords];
                optimizable.getParameters(this.paras);
                this.WBETA = 0.0;
                for (int i2 = 0; i2 < this.numTopics; ++i2) {
                    this.WBETAs[i2] = 0.0;
                }
                int numFeatures = this.numWords;
                for (int i3 = 0; i3 < this.numTopics; ++i3) {
                    for (int j = 0; j < this.numWords; ++j) {
                        this.parameters[i3][j] = this.paras[i3 * this.numWords + j];
                        this.b[j * this.numTopics + i3] = this.p_v != null ? Math.exp(this.parameters[i3][j]) * this.p_v[j] : Math.exp(this.parameters[i3][j]) * 1.0;
                        int n = i3;
                        this.WBETAs[n] = this.WBETAs[n] + this.b[j * this.numTopics + i3];
                    }
                }
                System.out.println("Convergence: " + converged);
            }
            for (int ii = 0; ii < this.numTokens; ++ii) {
                int i4 = ll.get(ii);
                int wi = this.words[i4];
                int di = this.docs[i4];
                int n = topic = this.topics[i4];
                this.topiccounts[n] = this.topiccounts[n] - 1;
                int wioffset = wi * this.numTopics;
                int dioffset = di * this.numTopics;
                int n2 = wioffset + topic;
                this.wordtopiccounts[n2] = this.wordtopiccounts[n2] - 1;
                int n3 = dioffset + topic;
                this.doctopiccounts[n3] = this.doctopiccounts[n3] - 1;
                double totprob = 0.0;
                for (int j = 0; j < this.numTopics; ++j) {
                    this.probs[j] = ((double)this.wordtopiccounts[wioffset + j] + this.b[wi * this.numTopics + j]) / ((double)this.topiccounts[j] + this.WBETAs[j]) * ((double)this.doctopiccounts[dioffset + j] + this.ALPHA);
                    totprob += this.probs[j];
                }
                double r = totprob * this.rn.nextDouble();
                topic = 0;
                for (double max = this.probs[0]; r > max; max += this.probs[++topic]) {
                }
                this.topics[i4] = topic;
                int n4 = wioffset + topic;
                this.wordtopiccounts[n4] = this.wordtopiccounts[n4] + 1;
                int n5 = dioffset + topic;
                this.doctopiccounts[n5] = this.doctopiccounts[n5] + 1;
                int n6 = topic;
                this.topiccounts[n6] = this.topiccounts[n6] + 1;
                this.tokenToTopic[ii] = topic;
            }
            for (i = 0; i < this.numWords * this.numTopics; ++i) {
                if (this.wordtopiccounts[i] >= 0) continue;
                this.wordtopiccounts[i] = 0;
            }
            for (i = 0; i < this.numDocs * this.numTopics; ++i) {
                if (this.doctopiccounts[i] >= 0) continue;
                this.doctopiccounts[i] = 0;
            }
            if (iter < burnIn || !(Math.random() < 0.5)) continue;
            this.updateDistributions();
        }
    }

    public double[][] getBetas() {
        double[][] betas = new double[this.numTopics][this.numWords];
        for (int i = 0; i < this.numTopics; ++i) {
            for (int j = 0; j < this.numWords; ++j) {
                betas[i][j] = this.paras[i * this.numWords + j];
            }
        }
        return betas;
    }

    @Override
    public int[] assignedTopicsToWords() {
        int[] res = new int[this.numWords];
        double max = 0.0;
        for (int i = 0; i < this.numWords; ++i) {
            max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (!(max < (double)this.wordtopiccounts[i * this.numTopics + j])) continue;
                max = this.wordtopiccounts[i * this.numTopics + j];
                res[i] = j;
            }
        }
        return res;
    }

    @Override
    public double[] assignedTopicsToWordsProbs() {
        double[] res = new double[this.numWords];
        double max = 0.0;
        for (int i = 0; i < this.numWords; ++i) {
            max = 0.0;
            double s = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                s += (double)this.wordtopiccounts[i * this.numTopics + j];
                if (!(max < (double)this.wordtopiccounts[i * this.numTopics + j])) continue;
                max = this.wordtopiccounts[i * this.numTopics + j];
                res[i] = this.wordtopiccounts[i * this.numTopics + j];
            }
        }
        return res;
    }

    @Override
    public int[] assignedTopicsToDocs() {
        int[] res = new int[this.numDocs];
        double max = 0.0;
        for (int i = 0; i < this.numDocs; ++i) {
            max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (!(max < (double)this.doctopiccounts[i * this.numTopics + j])) continue;
                max = this.doctopiccounts[i * this.numTopics + j];
                res[i] = j;
            }
        }
        return res;
    }

    @Override
    public void updateDistributions() {
        ++this.numStats;
        this.updateWordDistribution();
        this.updateDocumentDistribution();
    }

    @Override
    public void updateWordDistribution() {
        if (this.theta == null) {
            this.theta = new double[this.numTopics][this.numWords];
        }
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < this.numTopics; ++j) {
                double[] dArray = this.theta[j];
                int n = i;
                dArray[n] = dArray[n] + ((double)this.wordtopiccounts[i * this.numTopics + j] + this.b[i * this.numTopics + j]) / ((double)this.topiccounts[j] + this.WBETAs[j]);
            }
        }
    }

    @Override
    public void updateDocumentDistribution() {
        if (this.phi == null) {
            this.phi = new double[this.numTopics][this.numDocs];
        }
        for (int i = 0; i < this.numDocs; ++i) {
            int j;
            int docCounts = 0;
            for (j = 0; j < this.numTopics; ++j) {
                docCounts += this.doctopiccounts[i * this.numTopics + j];
            }
            for (j = 0; j < this.numTopics; ++j) {
                double[] dArray = this.phi[j];
                int n = i;
                dArray[n] = dArray[n] + ((double)this.doctopiccounts[i * this.numTopics + j] + this.ALPHA) / ((double)docCounts + (double)this.numTopics * this.ALPHA);
            }
        }
    }

    @Override
    public double[][] wordDistribution() {
        double[][] res = new double[this.numTopics][this.numWords];
        if (this.numStats > 0) {
            for (int i = 0; i < this.numWords; ++i) {
                for (int j = 0; j < this.numTopics; ++j) {
                    res[j][i] = this.theta[j][i] / (double)this.numStats;
                }
            }
            return res;
        }
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < this.numTopics; ++j) {
                res[j][i] = ((double)this.wordtopiccounts[i * this.numTopics + j] + this.b[i * this.numTopics + j]) / ((double)this.topiccounts[j] + this.WBETAs[j]);
            }
        }
        return res;
    }

    @Override
    public double[][] documentDistribution() {
        double[][] res = new double[this.numTopics][this.numDocs];
        if (this.numStats > 0) {
            for (int i = 0; i < this.numDocs; ++i) {
                for (int j = 0; j < this.numTopics; ++j) {
                    res[j][i] = this.phi[j][i] / (double)this.numStats;
                }
            }
            return res;
        }
        for (int i = 0; i < this.numDocs; ++i) {
            int j;
            int docCounts = 0;
            for (j = 0; j < this.numTopics; ++j) {
                docCounts += this.doctopiccounts[i * this.numTopics + j];
            }
            for (j = 0; j < this.numTopics; ++j) {
                res[j][i] = ((double)this.doctopiccounts[i * this.numTopics + j] + this.ALPHA) / ((double)docCounts + (double)this.numTopics * this.ALPHA);
            }
        }
        return res;
    }

    public static void main(String[] args) {
    }
}

