/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import cc.mallet.optimize.OptimizationException;
import com.rapidminer.kobra.opt.MyOrthantWiseLimitedMemoryBFGS;
import com.rapidminer.kobra.topicmodels.MyHashGompertzOptimizable;
import com.rapidminer.kobra.topicmodels.SamplersSLDA;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TDoubleIntHashMap;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.Variance;

public class SamplersGTLDA
extends SamplersSLDA {
    double[] times;
    double[] meanTimes;
    double[] varianceTimes;
    int[] uniqueIds;
    double maxTime = 0.0;
    double minTime = Double.MAX_VALUE;
    double[][] pGombertz;
    double[][] pi;
    Mean[] means = null;
    Variance[] vars = null;
    double[] maxes = null;
    double[] mins = null;
    TDoubleIntHashMap[] hsValues = null;
    double[][] testStatistics = null;

    public double dist(double x, double a, double b) {
        double tmp = b * Math.exp(-(b * x + a * Math.exp(-b * x))) * (1.0 + a * (1.0 - Math.exp(-b * x)));
        return tmp;
    }

    public double cumG(double x, double a, double b) {
        return (1.0 - Math.exp(-b * x)) * Math.exp(-a * Math.exp(-b * x));
    }

    public void init(int[] docIds, int[] wordIds, double[] ts, int[] ids, int numTopics, int numWords, int numDocs, int iter, double beta, double alpha, boolean locSeed, int seed) {
        int i;
        this.maxIter = iter;
        this.BETA = beta;
        this.ALPHA = alpha;
        int topic = 0;
        this.numTokens = wordIds.length;
        this.numTopics = numTopics;
        this.numDocs = numDocs;
        this.numWords = numWords;
        this.topics = new int[this.numTokens];
        this.wordtopiccounts = new int[numWords * numTopics];
        this.doctopiccounts = new int[numDocs * numTopics];
        this.topiccounts = new int[numTopics];
        this.words = wordIds;
        this.docs = docIds;
        if (locSeed) {
            this.seed = seed;
            this.rn = new Random(seed);
        } else {
            this.rn = new Random();
        }
        for (int i2 = 0; i2 < wordIds.length; ++i2) {
            int wi = this.words[i2];
            int di = this.docs[i2];
            this.topics[i2] = topic = this.rn.nextInt(numTopics);
            int n = wi * numTopics + topic;
            this.wordtopiccounts[n] = this.wordtopiccounts[n] + 1;
            int n2 = di * numTopics + topic;
            this.doctopiccounts[n2] = this.doctopiccounts[n2] + 1;
            int n3 = topic;
            this.topiccounts[n3] = this.topiccounts[n3] + 1;
        }
        this.times = ts;
        double mean = 0.0;
        double variance = 0.0;
        for (i = 0; i < this.times.length; ++i) {
            if (this.minTime > this.times[i]) {
                this.minTime = this.times[i];
            }
            if (!(this.maxTime < this.times[i])) continue;
            this.maxTime = this.times[i];
        }
        for (i = 0; i < this.times.length; ++i) {
        }
        this.pi = new double[numTopics][2];
        this.pGombertz = new double[numTopics][];
        this.meanTimes = new double[numTopics];
        this.varianceTimes = new double[numTopics];
        this.maxes = new double[numTopics];
        this.mins = new double[numTopics];
        for (i = 0; i < numTopics; ++i) {
            this.pi[i][0] = this.rn.nextDouble();
            this.pi[i][1] = this.rn.nextDouble();
            this.pGombertz[i] = this.pi[i];
            this.maxes[i] = 0.0;
            this.mins[i] = 2.0;
        }
        this.uniqueIds = ids;
    }

    @Override
    public void GibbsSampling() {
        int burnIn = (int)((double)this.maxIter * 0.9);
        int topic = 0;
        this.WBETA = (double)this.numWords * this.BETA;
        this.probs = new double[this.numTopics];
        this.tokenToTopic = new int[this.numTokens];
        TIntArrayList ll = new TIntArrayList(this.numTokens);
        for (int i = 0; i < this.numTokens; ++i) {
            ll.add(i);
        }
        ll.shuffle(this.rn);
        this.testStatistics = new double[this.maxIter][this.numTopics];
        this.hsValues = new TDoubleIntHashMap[this.numTopics];
        for (int iter = 0; iter < this.maxIter; ++iter) {
            int i;
            System.out.println("Current Gibbs Sampler iteration: " + iter);
            for (i = 0; i < this.numTopics; ++i) {
                this.hsValues[i] = new TDoubleIntHashMap();
            }
            for (int ii = 0; ii < this.numTokens; ++ii) {
                int i2 = ll.get(ii);
                int wi = this.words[i2];
                int di = this.docs[i2];
                int n = topic = this.topics[i2];
                this.topiccounts[n] = this.topiccounts[n] - 1;
                int wioffset = wi * this.numTopics;
                int dioffset = di * this.numTopics;
                int n2 = wioffset + topic;
                this.wordtopiccounts[n2] = this.wordtopiccounts[n2] - 1;
                int n3 = dioffset + topic;
                this.doctopiccounts[n3] = this.doctopiccounts[n3] - 1;
                double totprob = 0.0;
                for (int j = 0; j < this.numTopics; ++j) {
                    this.probs[j] = ((double)this.wordtopiccounts[wioffset + j] + this.BETA) / ((double)this.topiccounts[j] + this.WBETA) * ((double)this.doctopiccounts[dioffset + j] + this.ALPHA) * this.dist(this.times[di], this.pGombertz[j][0], this.pGombertz[j][1]);
                    totprob += this.probs[j];
                }
                double r = totprob * this.rn.nextDouble();
                topic = 0;
                for (double max = this.probs[0]; r > max; max += this.probs[++topic]) {
                }
                this.topics[i2] = topic;
                int n4 = wioffset + topic;
                this.wordtopiccounts[n4] = this.wordtopiccounts[n4] + 1;
                int n5 = dioffset + topic;
                this.doctopiccounts[n5] = this.doctopiccounts[n5] + 1;
                int n6 = topic;
                this.topiccounts[n6] = this.topiccounts[n6] + 1;
                int n7 = 1;
                if (this.hsValues[topic].contains(this.times[di])) {
                    n7 += this.hsValues[topic].get(this.times[di]);
                }
                this.hsValues[topic].put(this.times[di], n7);
                this.tokenToTopic[ii] = topic;
            }
            for (i = 0; i < this.numWords * this.numTopics; ++i) {
                if (this.wordtopiccounts[i] >= 0) continue;
                this.wordtopiccounts[i] = 0;
            }
            for (i = 0; i < this.numDocs * this.numTopics; ++i) {
                if (this.doctopiccounts[i] >= 0) continue;
                this.doctopiccounts[i] = 0;
            }
            for (i = 0; i < this.numTopics; ++i) {
                MyHashGompertzOptimizable opt = new MyHashGompertzOptimizable();
                opt.vals = this.hsValues[i];
                opt.alpha = this.rn.nextDouble();
                opt.beta = this.rn.nextDouble();
                opt.a = this.rn.nextDouble();
                opt.b = this.rn.nextDouble();
                MyOrthantWiseLimitedMemoryBFGS optimizer = new MyOrthantWiseLimitedMemoryBFGS(opt);
                boolean converged = false;
                double[] paras = new double[2];
                try {
                    converged = optimizer.optimize(100);
                }
                catch (OptimizationException e) {
                    e.printStackTrace();
                }
                opt.getParameters(paras);
                this.pGombertz[i][0] = Math.exp(paras[0]);
                this.pGombertz[i][1] = Math.exp(paras[1]);
                int counts = 0;
                double[] values = this.hsValues[i].keys();
                TDoubleArrayList tmp = new TDoubleArrayList(values);
                tmp.sort();
                values = tmp.toArray();
                for (int t = 0; t < values.length; ++t) {
                    counts += this.hsValues[i].get(values[t]);
                }
                double res = 0.0;
            }
            if (iter < burnIn || iter % 2 != 0) continue;
            this.updateDistributions();
        }
    }

    public TDoubleArrayList[] getAssignedTimes() {
        TDoubleArrayList[] res = new TDoubleArrayList[this.numTopics];
        for (int i = 0; i < this.numTopics; ++i) {
            TDoubleArrayList ls = new TDoubleArrayList();
            int nv = 0;
            for (double k : this.hsValues[i].keys()) {
                nv = this.hsValues[i].get(k);
                for (int kn = 0; kn < nv; ++kn) {
                    ls.add(k);
                }
            }
            res[i] = ls;
        }
        return res;
    }

    public double[][] getPi() {
        return this.pGombertz;
    }

    public static void main(String[] args) {
    }
}

