/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.kobra.topicmodels;

import com.rapidminer.kobra.topicmodels.SamplersLDA;
import java.util.Random;

public class SamplersATLDA
extends SamplersLDA {
    int[] words;
    int[] docs;
    int[] authors;
    int[] topics;
    int[] wordtopiccounts;
    int[] doctopiccounts;
    int[] authortopiccounts;
    int[] topiccounts;
    int[] authorcounts;
    int numTokens = 0;
    int numTopics = 2;
    int maxIter = 100;
    int numWords;
    int numDocs;
    int numAuthors;
    double BETA;
    double ALPHA;
    double WBETA;
    double[] probs;

    public void init(int[] docIds, int[] wordIds, int[] authorIds, int numTopics, int numWords, int numDocs, int numAuthors, int iter, double beta, double alpha) {
        int topic = 0;
        this.numTokens = wordIds.length;
        this.numTopics = numTopics;
        this.numDocs = numDocs;
        this.numWords = numWords;
        this.numAuthors = numAuthors;
        this.topics = new int[this.numTokens];
        this.wordtopiccounts = new int[numWords * numTopics];
        this.doctopiccounts = new int[numDocs * numTopics];
        this.authortopiccounts = new int[numAuthors * numTopics];
        this.topiccounts = new int[numTopics];
        this.authorcounts = new int[numAuthors];
        this.words = wordIds;
        this.docs = docIds;
        this.authors = authorIds;
        for (int i = 0; i < wordIds.length; ++i) {
            int wi = this.words[i];
            int di = this.docs[i];
            int ai = this.authors[i];
            this.topics[i] = topic = new Random().nextInt(numTopics);
            int n = wi * numTopics + topic;
            this.wordtopiccounts[n] = this.wordtopiccounts[n] + 1;
            int n2 = di * numTopics + topic;
            this.doctopiccounts[n2] = this.doctopiccounts[n2] + 1;
            int n3 = ai * numTopics + topic;
            this.authortopiccounts[n3] = this.authortopiccounts[n3] + 1;
            int n4 = ai;
            this.authorcounts[n4] = this.authorcounts[n4] + 1;
            int n5 = topic;
            this.topiccounts[n5] = this.topiccounts[n5] + 1;
        }
    }

    @Override
    public void GibbsSampling() {
        int topic = 0;
        this.WBETA = (double)this.numWords * this.BETA;
        double KALPHA = (double)this.numTopics * this.ALPHA;
        this.probs = new double[this.numTopics];
        for (int iter = 0; iter < this.maxIter; ++iter) {
            for (int ii = 0; ii < this.numTokens; ++ii) {
                int i = ii;
                int wi = this.words[i];
                int di = this.docs[i];
                int ai = this.authors[i];
                int n = topic = this.topics[i];
                this.topiccounts[n] = this.topiccounts[n] - 1;
                int n2 = ai;
                this.authorcounts[n2] = this.authorcounts[n2] - 1;
                int wioffset = wi * this.numTopics;
                int dioffset = di * this.numTopics;
                int aioffset = ai * this.numTopics;
                int n3 = wioffset + topic;
                this.wordtopiccounts[n3] = this.wordtopiccounts[n3] - 1;
                int n4 = dioffset + topic;
                this.doctopiccounts[n4] = this.doctopiccounts[n4] - 1;
                int n5 = aioffset + topic;
                this.authortopiccounts[n5] = this.authortopiccounts[n5] - 1;
                double totprob = 0.0;
                for (int j = 0; j < this.numTopics; ++j) {
                    this.probs[j] = ((double)this.wordtopiccounts[wioffset + j] + this.BETA) / ((double)this.topiccounts[j] + this.WBETA) * ((double)this.authortopiccounts[aioffset + j] + this.ALPHA) / ((double)this.authorcounts[ai] + KALPHA);
                    totprob += this.probs[j];
                }
                double r = totprob * (double)new Random().nextInt();
                topic = 0;
                for (double max = this.probs[0]; r > max; max += this.probs[++topic]) {
                }
                this.topics[i] = topic;
                int n6 = wioffset + topic;
                this.wordtopiccounts[n6] = this.wordtopiccounts[n6] + 1;
                int n7 = dioffset + topic;
                this.doctopiccounts[n7] = this.doctopiccounts[n7] + 1;
                int n8 = aioffset + topic;
                this.authortopiccounts[n8] = this.authortopiccounts[n8] + 1;
                int n9 = topic;
                this.topiccounts[n9] = this.topiccounts[n9] + 1;
                int n10 = ai;
                this.authorcounts[n10] = this.authorcounts[n10] + 1;
            }
        }
    }

    public int[] assignedTopicsToAuthors() {
        int[] res = new int[this.numAuthors];
        double max = 0.0;
        for (int i = 0; i < this.numAuthors; ++i) {
            max = 0.0;
            for (int j = 0; j < this.numTopics; ++j) {
                if (!(max < (double)this.authortopiccounts[i * this.numTopics + j])) continue;
                max = this.authortopiccounts[i * this.numTopics + j];
                res[i] = j;
            }
        }
        return res;
    }

    public static void main(String[] args) {
    }
}

